/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.function.BaseFunction;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import software.amazon.lambda.powertools.common.internal.ClassPreLoader;
import software.amazon.lambda.powertools.utilities.JsonConfig;
import software.amazon.lambda.powertools.validation.ValidationUtils;

public class ValidationConfig
implements Resource {
    private SpecVersion.VersionFlag jsonSchemaVersion = SpecVersion.VersionFlag.V7;
    private JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.jsonSchemaVersion);

    static {
        Core.getGlobalContext().register((Resource)ValidationConfig.get());
    }

    private ValidationConfig() {
    }

    public static ValidationConfig get() {
        return ConfigHolder.instance;
    }

    public SpecVersion.VersionFlag getSchemaVersion() {
        return this.jsonSchemaVersion;
    }

    public void setSchemaVersion(SpecVersion.VersionFlag version) {
        if (version != this.jsonSchemaVersion) {
            this.jsonSchemaVersion = version;
            this.factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)version);
        }
    }

    public <T extends BaseFunction> void addFunction(T function) {
        JsonConfig.get().addFunction(function);
    }

    public JsonSchemaFactory getFactory() {
        return this.factory;
    }

    public JmesPath<JsonNode> getJmesPath() {
        return JsonConfig.get().getJmesPath();
    }

    public ObjectMapper getObjectMapper() {
        return JsonConfig.get().getObjectMapper();
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        this.getObjectMapper();
        this.getJmesPath();
        this.getFactory();
        String sampleSchema = "{\"type\":\"object\"}";
        JsonSchema schema = ValidationUtils.getJsonSchema(sampleSchema);
        ValidationUtils.validate("{\"test\":\"dummy\"}", schema);
        ClassPreLoader.preloadClasses();
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
    }

    private static class ConfigHolder {
        private static final ValidationConfig instance = new ValidationConfig();

        private ConfigHolder() {
        }
    }
}

