/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import software.amazon.lambda.snapstart.ByteCodeIntrospector;
import software.amazon.lambda.snapstart.ReturnValueRandomnessPropertyDatabase;

public class LambdaHandlerInitedWithRandomValue
extends OpcodeStackDetector {
    private static final String SNAP_START_BUG = "AWS_LAMBDA_SNAP_START_BUG";
    private final BugReporter bugReporter;
    private boolean isLambdaHandlerClass;
    private boolean isCracResource;
    private boolean inInitializer;
    private boolean inStaticInitializer;
    private boolean inCracBeforeCheckpoint;
    private ByteCodeIntrospector introspector;
    private ReturnValueRandomnessPropertyDatabase database;

    public LambdaHandlerInitedWithRandomValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.isLambdaHandlerClass = false;
        this.isCracResource = false;
        this.inInitializer = false;
        this.inStaticInitializer = false;
        this.inCracBeforeCheckpoint = false;
        this.introspector = new ByteCodeIntrospector();
    }

    public void visit(JavaClass obj) {
        this.inInitializer = false;
        this.inStaticInitializer = false;
        this.inCracBeforeCheckpoint = false;
        XClass xClass = this.getXClass();
        this.isLambdaHandlerClass = this.introspector.isLambdaHandler(xClass);
        this.isCracResource = this.introspector.isCracResource(xClass);
    }

    public boolean shouldVisitCode(Code code) {
        boolean shouldVisit = false;
        if (this.isLambdaHandlerClass) {
            this.inStaticInitializer = this.getMethodName().equals("<clinit>");
            this.inInitializer = this.getMethodName().equals("<init>");
            this.database = (ReturnValueRandomnessPropertyDatabase)((Object)Global.getAnalysisCache().getDatabase(ReturnValueRandomnessPropertyDatabase.class));
            if (this.inInitializer || this.inStaticInitializer) {
                shouldVisit = true;
            }
        } else {
            this.inStaticInitializer = false;
            this.inInitializer = false;
        }
        if (this.isCracResource) {
            this.inCracBeforeCheckpoint = this.getMethodName().equals("beforeCheckpoint");
            if (this.inCracBeforeCheckpoint) {
                shouldVisit = true;
            }
        } else {
            this.inCracBeforeCheckpoint = false;
        }
        return shouldVisit;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 179: 
            case 181: {
                XField xField = this.getXFieldOperand();
                if (!this.getXClass().getXFields().contains(xField) || !this.isOperandStackTopBadRng() && !this.isRandomValue() && !this.isOperandStackTopTimestamp()) break;
                this.reportBug(xField);
                break;
            }
        }
    }

    private boolean isOperandStackTopBadRng() {
        return this.introspector.isRandomType(this.getStack());
    }

    private boolean isRandomValue() {
        XMethod returningMethod = this.getReturningMethodOrNull();
        if (returningMethod == null) {
            return false;
        }
        Boolean returnsRandom = (Boolean)this.database.getProperty((FieldOrMethodDescriptor)returningMethod.getMethodDescriptor());
        return returnsRandom != null && returnsRandom != false;
    }

    private boolean isOperandStackTopTimestamp() {
        return this.introspector.isTimestamp(this.getStack());
    }

    private void reportBug(XField xField) {
        BugInstance bug = new BugInstance((Detector)this, SNAP_START_BUG, 1).addClassAndMethod(this.getXMethod()).addField(xField).addSourceLine((BytecodeScanningDetector)this);
        this.bugReporter.reportBug(bug);
    }

    private XMethod getReturningMethodOrNull() {
        OpcodeStack.Item retValItem = this.getStack().getStackItem(0);
        return retValItem.getReturnValueOf();
    }
}

