/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.ba.interproc.MethodPropertyDatabase;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CallGraph {
    private Map<MethodDescriptor, Set<MethodDescriptor>> callGraph = new HashMap<MethodDescriptor, Set<MethodDescriptor>>();

    public boolean isInCallGraph(MethodDescriptor method) {
        return this.callGraph.containsKey(method);
    }

    public void record(MethodDescriptor caller, MethodDescriptor called) {
        Set calledBy = this.callGraph.computeIfAbsent(called, k -> new HashSet());
        calledBy.add(caller);
    }

    public void flushCallersToDatabase(MethodDescriptor called, MethodPropertyDatabase<Boolean> database, Boolean value) {
        LinkedList<MethodDescriptor> queue = new LinkedList<MethodDescriptor>();
        queue.push(called);
        while (!queue.isEmpty()) {
            MethodDescriptor m = (MethodDescriptor)queue.remove();
            database.setProperty((FieldOrMethodDescriptor)m, (Object)value);
            this.queueCallers(m, queue);
        }
    }

    private void queueCallers(MethodDescriptor called, LinkedList<MethodDescriptor> queue) {
        Set<MethodDescriptor> callers = this.callGraph.remove(called);
        if (callers != null) {
            for (MethodDescriptor caller : callers) {
                queue.push(caller);
            }
        }
    }
}

