/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PlaceholderUtils {
    static String ERROR_NUMBER_OF_PARAMS_MISMATCH = "Number of placeholders does not match number of parameters";
    private static Pattern REGEX_NAMED_PLACEHOLDER = Pattern.compile(":([a-zA-Z0-9_]+)");

    PlaceholderUtils() {
    }

    public static PlaceholderConvertResult convertToNamed(String sql, Object ... parameters) {
        String[] parts = sql.split("\\?");
        Preconditions.checkArgument((boolean)PlaceholderUtils.numberOfParametersMatches(parts, parameters), (Object)ERROR_NUMBER_OF_PARAMS_MISMATCH);
        StringBuilder resultingSql = new StringBuilder(parts[0]);
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        for (int i = 1; i < parts.length; ++i) {
            resultingSql.append(":").append(i);
            resultingSql.append(parts[i]);
            parametersMap.put(String.valueOf(i), parameters[i - 1]);
        }
        return new PlaceholderConvertResult(resultingSql.toString(), parametersMap);
    }

    private static boolean numberOfParametersMatches(String[] parts, Object[] parameters) {
        return parts.length - 1 == parameters.length;
    }

    public static Set<String> findAll(String sql) {
        Matcher matcher = REGEX_NAMED_PLACEHOLDER.matcher(sql);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public static final class PlaceholderConvertResult {
        public final String sql;
        public final Map<String, Object> parameters;

        public PlaceholderConvertResult(String sql, Map<String, Object> parameters) {
            this.sql = sql;
            this.parameters = parameters;
        }

        public String getSql() {
            return this.sql;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderConvertResult)) {
                return false;
            }
            PlaceholderConvertResult other = (PlaceholderConvertResult)o;
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            Map<String, Object> this$parameters = this.getParameters();
            Map<String, Object> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            Map<String, Object> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderUtils.PlaceholderConvertResult(sql=" + this.getSql() + ", parameters=" + this.getParameters() + ")";
        }
    }
}

