/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.address_lookup_table;

import java.util.List;
import java.util.SequencedCollection;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;

public final class AddressLookupTableProgram {
    public static ProgramDerivedAddress findLookupTableAddress(SolanaAccounts solanaAccounts, PublicKey authorityAccount, long recentSlot) {
        byte[] recentSlotBytes = new byte[8];
        ByteUtil.putInt64LE((byte[])recentSlotBytes, (int)0, (long)recentSlot);
        return PublicKey.findProgramAddress(List.of(authorityAccount.toByteArray(), recentSlotBytes), (PublicKey)solanaAccounts.addressLookupTableProgram());
    }

    public static Instruction createLookupTable(SolanaAccounts solanaAccounts, PublicKey uninitializedTableAccount, PublicKey baseAndAuthorityKey, PublicKey funderAccount, long recentSlot, int bumpSeed) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)uninitializedTableAccount), AccountMeta.createReadOnlySigner((PublicKey)baseAndAuthorityKey), AccountMeta.createWritableSigner((PublicKey)funderAccount), solanaAccounts.readSystemProgram());
        byte[] data = new byte[13];
        Instructions.CreateLookupTable.write(data, 0);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)recentSlot);
        data[12] = (byte)bumpSeed;
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])data);
    }

    public static Instruction freezeLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tableAccount), AccountMeta.createReadOnlySigner((PublicKey)authorityAccount));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])Instructions.FreezeLookupTable.data);
    }

    private static byte[] createExtendTableData(SequencedCollection<PublicKey> newAddresses) {
        byte[] data = new byte[12 + 32 * newAddresses.size()];
        Instructions.ExtendLookupTable.write(data, 0);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)newAddresses.size());
        int i = 12;
        for (PublicKey a : newAddresses) {
            i += a.write(data, i);
        }
        return data;
    }

    public static Instruction extendLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount, SequencedCollection<PublicKey> newAddresses) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tableAccount), AccountMeta.createReadOnlySigner((PublicKey)authorityAccount));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])AddressLookupTableProgram.createExtendTableData(newAddresses));
    }

    public static Instruction extendLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount, PublicKey funderAccount, SequencedCollection<PublicKey> newAddresses) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tableAccount), AccountMeta.createReadOnlySigner((PublicKey)authorityAccount), AccountMeta.createWritableSigner((PublicKey)funderAccount), solanaAccounts.readSystemProgram());
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])AddressLookupTableProgram.createExtendTableData(newAddresses));
    }

    public static Instruction extendLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount, List<PublicKey> newAddresses) {
        return AddressLookupTableProgram.extendLookupTable(solanaAccounts, tableAccount, authorityAccount, newAddresses);
    }

    public static Instruction extendLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount, PublicKey funderAccount, List<PublicKey> newAddresses) {
        return AddressLookupTableProgram.extendLookupTable(solanaAccounts, tableAccount, authorityAccount, funderAccount, newAddresses);
    }

    public static Instruction deactivateLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tableAccount), AccountMeta.createReadOnlySigner((PublicKey)authorityAccount));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])Instructions.DeactivateLookupTable.data);
    }

    public static Instruction closeLookupTable(SolanaAccounts solanaAccounts, PublicKey tableAccount, PublicKey authorityAccount, PublicKey lamportRecipient) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tableAccount), AccountMeta.createReadOnlySigner((PublicKey)authorityAccount), AccountMeta.createWrite((PublicKey)lamportRecipient));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAddressLookupTableProgram(), keys, (byte[])Instructions.CloseLookupTable.data);
    }

    private AddressLookupTableProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        CreateLookupTable{}
        ,
        FreezeLookupTable,
        ExtendLookupTable{}
        ,
        DeactivateLookupTable,
        CloseLookupTable;

        private final byte[] data = Discriminator.serializeDiscriminator((Enum)this);

        public byte[] data() {
            return this.data;
        }
    }
}

