/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.clients;

import java.util.Collection;
import java.util.List;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.Signer;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.accounts.token.TokenAccount;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;
import software.sava.rpc.json.http.client.SolanaRpcClient;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.clients.NativeProgramAccountClientImpl;
import software.sava.solana.programs.clients.NativeProgramClient;
import software.sava.solana.programs.stake.StakeAccount;
import software.sava.solana.programs.stake.StakeAuthorize;
import software.sava.solana.programs.stake.StakeState;
import software.sava.solana.programs.token.AssociatedTokenProgram;

public interface NativeProgramAccountClient {
    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, PublicKey owner, AccountMeta feePayer) {
        NativeProgramClient nativeClient = NativeProgramClient.createClient(accounts);
        return new NativeProgramAccountClientImpl(nativeClient, owner, feePayer);
    }

    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, AccountMeta ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(accounts, ownerAndFeePayer.publicKey(), ownerAndFeePayer);
    }

    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, PublicKey ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(accounts, AccountMeta.createFeePayer((PublicKey)ownerAndFeePayer));
    }

    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, Signer ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(accounts, AccountMeta.createFeePayer((PublicKey)ownerAndFeePayer.publicKey()));
    }

    public static NativeProgramAccountClient createClient(AccountMeta ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, ownerAndFeePayer);
    }

    public static NativeProgramAccountClient createClient(PublicKey ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, ownerAndFeePayer);
    }

    public static NativeProgramAccountClient createClient(Signer ownerAndFeePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, ownerAndFeePayer);
    }

    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, PublicKey owner, PublicKey feePayer) {
        return NativeProgramAccountClient.createClient(accounts, owner, AccountMeta.createFeePayer((PublicKey)feePayer));
    }

    public static NativeProgramAccountClient createClient(SolanaAccounts accounts, PublicKey owner, Signer feePayer) {
        return NativeProgramAccountClient.createClient(accounts, owner, AccountMeta.createFeePayer((PublicKey)feePayer.publicKey()));
    }

    public static NativeProgramAccountClient createClient(PublicKey owner, AccountMeta feePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, owner, feePayer);
    }

    public static NativeProgramAccountClient createClient(PublicKey owner, PublicKey feePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, owner, feePayer);
    }

    public static NativeProgramAccountClient createClient(PublicKey owner, Signer feePayer) {
        return NativeProgramAccountClient.createClient(SolanaAccounts.MAIN_NET, owner, feePayer);
    }

    public PublicKey ownerPublicKey();

    public AccountMeta feePayer();

    public SolanaAccounts solanaAccounts();

    public ProgramDerivedAddress wrappedSolPDA();

    public NativeProgramClient nativeProgramClient();

    public Transaction createTransaction(PublicKey var1, int var2, long var3, Instruction var5);

    public Transaction createTransaction(AccountMeta var1, int var2, long var3, Instruction var5);

    public Transaction createTransaction(Instruction var1);

    public Transaction createTransaction(List<Instruction> var1);

    public Transaction createTransaction(int var1, long var2, Instruction var4);

    public Transaction createTransaction(int var1, long var2, List<Instruction> var4);

    public Transaction createTransaction(int var1, long var2, Transaction var4);

    public Transaction createTransaction(PublicKey var1, int var2, long var3, Instruction var5, AddressLookupTable var6);

    public Transaction createTransaction(AccountMeta var1, int var2, long var3, Instruction var5, AddressLookupTable var6);

    public Transaction createTransaction(Instruction var1, AddressLookupTable var2);

    public Transaction createTransaction(List<Instruction> var1, AddressLookupTable var2);

    public Transaction createTransaction(int var1, long var2, Instruction var4, AddressLookupTable var5);

    public Transaction createTransaction(int var1, long var2, List<Instruction> var4, AddressLookupTable var5);

    public Transaction createTransaction(PublicKey var1, int var2, long var3, Instruction var5, LookupTableAccountMeta[] var6);

    public Transaction createTransaction(AccountMeta var1, int var2, long var3, Instruction var5, LookupTableAccountMeta[] var6);

    public Transaction createTransaction(Instruction var1, LookupTableAccountMeta[] var2);

    public Transaction createTransaction(List<Instruction> var1, LookupTableAccountMeta[] var2);

    public Transaction createTransaction(int var1, long var2, Instruction var4, LookupTableAccountMeta[] var5);

    public Transaction createTransaction(int var1, long var2, List<Instruction> var4, LookupTableAccountMeta[] var5);

    public ProgramDerivedAddress findATA(PublicKey var1);

    public ProgramDerivedAddress findATA(PublicKey var1, PublicKey var2);

    public ProgramDerivedAddress findATAForFeePayer(PublicKey var1);

    public ProgramDerivedAddress findATAForFeePayer(PublicKey var1, PublicKey var2);

    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchTokenAccounts(SolanaRpcClient var1, PublicKey var2);

    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchTokenAccounts(SolanaRpcClient var1);

    public CompletableFuture<List<AccountInfo<TokenAccount>>> fetchToken2022Accounts(SolanaRpcClient var1);

    public Instruction syncNative();

    public List<Instruction> wrapSOL(long var1);

    public Instruction unwrapSOL();

    public Instruction createAccount(PublicKey var1, long var2, long var4, PublicKey var6);

    public Instruction createAccountWithSeed(AccountWithSeed var1, long var2, long var4, PublicKey var6);

    public Instruction transferSolLamports(PublicKey var1, long var2);

    public Instruction allocateAccountSpaceWithSeed(AccountWithSeed var1, long var2, PublicKey var4);

    public AccountWithSeed createOffCurveAccountWithSeed(String var1, PublicKey var2);

    public AccountWithSeed createOffCurveStakeAccountWithSeed(String var1);

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient var1, StakeState var2);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient rpcClient) {
        return this.fetchStakeAccountsByStakeAuthority(rpcClient, StakeState.Stake);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient var1, StakeState var2);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient rpcClient) {
        return this.fetchStakeAccountsByWithdrawAuthority(rpcClient, StakeState.Stake);
    }

    public CompletableFuture<List<AccountInfo<AddressLookupTable>>> fetchLookupTableAccountsByAuthority(SolanaRpcClient var1);

    public Instruction createStakeAccount(PublicKey var1, long var2);

    public Instruction createStakeAccountWithSeed(AccountWithSeed var1, long var2);

    public Instruction allocateStakeAccountWithSeed(AccountWithSeed var1);

    public Instruction transferSolLamportsWithSeed(AccountWithSeed var1, PublicKey var2, long var3, PublicKey var5);

    default public Instruction transferSolLamportsWithSeed(AccountWithSeed accountWithSeed, long lamports, PublicKey programOwner) {
        return this.transferSolLamportsWithSeed(accountWithSeed, this.ownerPublicKey(), lamports, programOwner);
    }

    public Instruction transferToken(AccountMeta var1, PublicKey var2, PublicKey var3, long var4);

    default public Instruction transferToken(PublicKey fromTokenAccount, PublicKey toTokenAccount, long scaledAmount) {
        return this.transferToken(this.solanaAccounts().invokedTokenProgram(), fromTokenAccount, toTokenAccount, scaledAmount);
    }

    public Instruction transferTokenChecked(AccountMeta var1, PublicKey var2, PublicKey var3, long var4, int var6, PublicKey var7);

    default public Instruction transferTokenChecked(PublicKey fromTokenAccount, PublicKey toTokenAccount, long scaledAmount, int decimals, PublicKey tokenMint) {
        return this.transferTokenChecked(this.solanaAccounts().invokedTokenProgram(), fromTokenAccount, toTokenAccount, scaledAmount, decimals, tokenMint);
    }

    public Instruction closeTokenAccount(AccountMeta var1, PublicKey var2);

    default public Instruction closeTokenAccount(PublicKey tokenAccount) {
        return this.closeTokenAccount(this.solanaAccounts().invokedTokenProgram(), tokenAccount);
    }

    default public Instruction createATAForFundedBy(boolean idempotent, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, this.solanaAccounts(), fundingAccount, pda, owner, mint, tokenProgram);
    }

    default public Instruction createATAForFundedBy(boolean idempotent, PublicKey fundingAccount, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, this.solanaAccounts(), fundingAccount, owner, mint, tokenProgram);
    }

    default public Instruction createATAForFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedBy(idempotent, this.feePayer().publicKey(), pda, owner, mint, tokenProgram);
    }

    default public Instruction createATAForFundedByFeePayer(boolean idempotent, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedBy(idempotent, this.feePayer().publicKey(), owner, mint, tokenProgram);
    }

    default public Instruction createATAForFundedByOwner(boolean idempotent, PublicKey pda, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedBy(idempotent, this.ownerPublicKey(), pda, owner, mint, tokenProgram);
    }

    default public Instruction createATAForFundedByOwner(boolean idempotent, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedBy(idempotent, this.ownerPublicKey(), owner, mint, tokenProgram);
    }

    default public Instruction createATAForOwnerFundedByOwner(boolean idempotent, PublicKey pda, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByOwner(idempotent, pda, this.ownerPublicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForOwnerFundedByOwner(boolean idempotent, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByOwner(idempotent, this.ownerPublicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForOwnerFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByFeePayer(idempotent, pda, this.ownerPublicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForOwnerFundedByFeePayer(boolean idempotent, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByFeePayer(idempotent, this.ownerPublicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForFeePayerFundedByOwner(boolean idempotent, PublicKey pda, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByOwner(idempotent, pda, this.feePayer().publicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForFeePayerFundedByOwner(boolean idempotent, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByOwner(idempotent, this.feePayer().publicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForFeePayerFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByFeePayer(idempotent, pda, this.feePayer().publicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForFeePayerFundedByFeePayer(boolean idempotent, PublicKey mint, AccountMeta tokenProgram) {
        return this.createATAForFundedByFeePayer(idempotent, this.feePayer().publicKey(), mint, tokenProgram);
    }

    default public Instruction createATAForFundedBy(boolean idempotent, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.createATA(idempotent, this.solanaAccounts(), fundingAccount, pda, owner, mint);
    }

    default public Instruction createATAForFundedBy(boolean idempotent, PublicKey fundingAccount, PublicKey owner, PublicKey mint) {
        return this.createATAForFundedBy(idempotent, fundingAccount, owner, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey owner, PublicKey mint) {
        return this.createATAForFundedByFeePayer(idempotent, pda, owner, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFundedByFeePayer(boolean idempotent, PublicKey owner, PublicKey mint) {
        return this.createATAForFundedByFeePayer(idempotent, owner, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFundedByOwner(boolean idempotent, PublicKey pda, PublicKey owner, PublicKey mint) {
        return this.createATAForFundedByOwner(idempotent, pda, owner, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFundedByOwner(boolean idempotent, PublicKey owner, PublicKey mint) {
        return this.createATAForFundedByOwner(idempotent, owner, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForOwnerFundedByOwner(boolean idempotent, PublicKey pda, PublicKey mint) {
        return this.createATAForOwnerFundedByOwner(idempotent, pda, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForOwnerFundedByOwner(boolean idempotent, PublicKey mint) {
        return this.createATAForOwnerFundedByOwner(idempotent, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForOwnerFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey mint) {
        return this.createATAForOwnerFundedByFeePayer(idempotent, pda, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForOwnerFundedByFeePayer(boolean idempotent, PublicKey mint) {
        return this.createATAForOwnerFundedByFeePayer(idempotent, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFeePayerFundedByOwner(boolean idempotent, PublicKey pda, PublicKey mint) {
        return this.createATAForFeePayerFundedByOwner(idempotent, pda, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFeePayerFundedByOwner(boolean idempotent, PublicKey mint) {
        return this.createATAForFeePayerFundedByOwner(idempotent, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFeePayerFundedByFeePayer(boolean idempotent, PublicKey pda, PublicKey mint) {
        return this.createATAForFeePayerFundedByFeePayer(idempotent, pda, mint, this.solanaAccounts().readTokenProgram());
    }

    default public Instruction createATAForFeePayerFundedByFeePayer(boolean idempotent, PublicKey mint) {
        return this.createATAForFeePayerFundedByFeePayer(idempotent, mint, this.solanaAccounts().readTokenProgram());
    }

    public Instruction initializeStakeAccount(PublicKey var1, PublicKey var2);

    public Instruction initializeStakeAccount(PublicKey var1);

    public Instruction initializeStakeAccountChecked(PublicKey var1, PublicKey var2);

    public Instruction initializeStakeAccountChecked(PublicKey var1);

    public Instruction authorizeStakeAccount(PublicKey var1, PublicKey var2, PublicKey var3, StakeAuthorize var4);

    public Instruction authorizeStakeAccount(PublicKey var1, PublicKey var2, StakeAuthorize var3);

    default public Instruction authorizeStakeAccount(StakeAccount stakeAccount, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccount(stakeAccount.address(), stakeAuthorize == StakeAuthorize.Staker ? stakeAccount.stakeAuthority() : stakeAccount.withdrawAuthority(), stakeAuthorize);
    }

    public Instruction authorizeStakeAccountChecked(PublicKey var1, PublicKey var2, PublicKey var3, StakeAuthorize var4);

    public Instruction authorizeStakeAccountChecked(PublicKey var1, PublicKey var2, StakeAuthorize var3);

    default public Instruction authorizeStakeAccountChecked(StakeAccount stakeAccount, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccountChecked(stakeAccount.address(), stakeAuthorize == StakeAuthorize.Staker ? stakeAccount.stakeAuthority() : stakeAccount.withdrawAuthority(), stakeAuthorize);
    }

    public Instruction delegateStakeAccount(PublicKey var1, PublicKey var2);

    public Instruction deactivateStakeAccount(PublicKey var1);

    public Instruction withdrawStakeAccount(StakeAccount var1, long var2);

    default public Instruction closeStakeAccount(AccountInfo<StakeAccount> stakeAccountInfo) {
        StakeAccount stakeAccount = (StakeAccount)stakeAccountInfo.data();
        return this.withdrawStakeAccount(stakeAccount, stakeAccountInfo.lamports());
    }

    default public List<Instruction> closeStakeAccounts(Collection<AccountInfo<StakeAccount>> stakeAccounts) {
        return stakeAccounts.stream().map(this::closeStakeAccount).toList();
    }

    public ProgramDerivedAddress findLookupTableAddress(long var1);

    public Instruction createLookupTable(ProgramDerivedAddress var1, long var2);

    public Instruction freezeLookupTable(PublicKey var1);

    public Instruction extendLookupTable(PublicKey var1, SequencedCollection<PublicKey> var2);

    default public Instruction extendLookupTable(PublicKey tableAccount, List<PublicKey> newAddresses) {
        return this.extendLookupTable(tableAccount, (SequencedCollection<PublicKey>)newAddresses);
    }

    public Instruction deactivateLookupTable(PublicKey var1);

    public Instruction closeLookupTable(PublicKey var1);
}

