/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.clients;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.sysvar.Clock;
import software.sava.core.tx.Instruction;
import software.sava.rpc.json.http.client.SolanaRpcClient;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.clients.NativeProgramAccountClient;
import software.sava.solana.programs.clients.NativeProgramClientImpl;
import software.sava.solana.programs.stake.LockUp;
import software.sava.solana.programs.stake.StakeAccount;
import software.sava.solana.programs.stake.StakeAuthorize;
import software.sava.solana.programs.stake.StakeState;

public interface NativeProgramClient {
    public static NativeProgramClient createClient(SolanaAccounts programs) {
        return new NativeProgramClientImpl(programs);
    }

    public static NativeProgramClient createClient() {
        return NativeProgramClient.createClient(SolanaAccounts.MAIN_NET);
    }

    public static CompletableFuture<Long> getMinimumBalanceForStakeAccount(SolanaRpcClient rpcClient) {
        return rpcClient.getMinimumBalanceForRentExemption(200L);
    }

    public SolanaAccounts accounts();

    public NativeProgramAccountClient createAccountClient(AccountMeta var1);

    public NativeProgramAccountClient createAccountClient(PublicKey var1, AccountMeta var2);

    public CompletableFuture<AccountInfo<Clock>> fetchClockSysVar(SolanaRpcClient var1);

    public Instruction computeUnitLimit(int var1);

    public Instruction computeUnitPrice(long var1);

    public Instruction allocateAccountSpace(PublicKey var1, long var2);

    public Instruction syncNative(PublicKey var1);

    default public Instruction allocateStakeAccount(PublicKey newAccountPublicKey) {
        return this.allocateAccountSpace(newAccountPublicKey, 200L);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient var1, StakeState var2, PublicKey var3);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient rpcClient, PublicKey staker) {
        return this.fetchStakeAccountsByStakeAuthority(rpcClient, StakeState.Stake, staker);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient var1, StakeState var2, PublicKey var3);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient rpcClient, PublicKey withdrawer) {
        return this.fetchStakeAccountsByWithdrawAuthority(rpcClient, StakeState.Stake, withdrawer);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAndWithdrawAuthority(SolanaRpcClient var1, StakeState var2, PublicKey var3);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAndWithdrawAuthority(SolanaRpcClient rpcClient, PublicKey withdrawer) {
        return this.fetchStakeAccountsByStakeAndWithdrawAuthority(rpcClient, StakeState.Stake, withdrawer);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsWithCustodian(SolanaRpcClient var1, StakeState var2, PublicKey var3);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsWithCustodian(SolanaRpcClient rpcClient, PublicKey custodian) {
        return this.fetchStakeAccountsWithCustodian(rpcClient, StakeState.Stake, custodian);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidator(SolanaRpcClient var1, StakeState var2, PublicKey var3);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidator(SolanaRpcClient rpcClient, PublicKey voteAccount) {
        return this.fetchStakeAccountsForValidator(rpcClient, StakeState.Stake, voteAccount);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndWithdrawAuthority(SolanaRpcClient var1, StakeState var2, PublicKey var3, PublicKey var4);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndWithdrawAuthority(SolanaRpcClient rpcClient, PublicKey voteAccount, PublicKey withdrawAuthority) {
        return this.fetchStakeAccountsForValidatorAndWithdrawAuthority(rpcClient, StakeState.Stake, voteAccount, withdrawAuthority);
    }

    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndStakeAndWithdrawAuthority(SolanaRpcClient var1, StakeState var2, PublicKey var3, PublicKey var4);

    default public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndStakeAndWithdrawAuthority(SolanaRpcClient rpcClient, PublicKey voteAccount, PublicKey withdrawAuthority) {
        return this.fetchStakeAccountsForValidatorAndStakeAndWithdrawAuthority(rpcClient, StakeState.Stake, voteAccount, withdrawAuthority);
    }

    public CompletableFuture<List<AccountInfo<AddressLookupTable>>> fetchLookupTableAccountsByAuthority(SolanaRpcClient var1, PublicKey var2);

    public Instruction deactivateDelinquentStake(PublicKey var1, PublicKey var2, PublicKey var3);

    public Instruction setStakeAccountLockup(PublicKey var1, PublicKey var2, Instant var3, OptionalLong var4, PublicKey var5);

    default public Instruction setStakeAccountLockupChecked(PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, Instant timestamp, OptionalLong epoch) {
        return this.setStakeAccountLockupChecked(initializedStakeAccount, lockupOrWithdrawAuthority, null, timestamp, epoch);
    }

    public Instruction setStakeAccountLockupChecked(PublicKey var1, PublicKey var2, PublicKey var3, Instant var4, OptionalLong var5);

    public Instruction authorizeStakeAccount(PublicKey var1, PublicKey var2, PublicKey var3, PublicKey var4, StakeAuthorize var5);

    default public Instruction authorizeStakeAccount(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccount(stakeAccount, stakeOrWithdrawAuthority, null, newAuthority, stakeAuthorize);
    }

    default public Instruction authorizeStakeAccount(StakeAccount stakeAccount, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccount(stakeAccount.address(), stakeAuthorize == StakeAuthorize.Staker ? stakeAccount.stakeAuthority() : stakeAccount.withdrawAuthority(), newAuthority, stakeAuthorize);
    }

    public Instruction authorizeStakeAccountChecked(PublicKey var1, PublicKey var2, PublicKey var3, PublicKey var4, StakeAuthorize var5);

    default public Instruction authorizeStakeAccountChecked(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newStakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccountChecked(stakeAccount, stakeOrWithdrawAuthority, newStakeOrWithdrawAuthority, null, stakeAuthorize);
    }

    default public Instruction authorizeStakeAccountChecked(StakeAccount stakeAccount, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        return this.authorizeStakeAccountChecked(stakeAccount.address(), stakeAuthorize == StakeAuthorize.Staker ? stakeAccount.stakeAuthority() : stakeAccount.withdrawAuthority(), newAuthority, stakeAuthorize);
    }

    public Instruction authorizeStakeAccountWithSeed(PublicKey var1, AccountWithSeed var2, PublicKey var3, PublicKey var4, StakeAuthorize var5, PublicKey var6);

    default public Instruction authorizeStakeAccountWithSeed(PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        return this.authorizeStakeAccountWithSeed(stakeAccount, baseKeyOrWithdrawAuthority, null, newAuthorizedPublicKey, stakeAuthorize, authorityOwner);
    }

    public Instruction authorizeStakeAccountCheckedWithSeed(PublicKey var1, AccountWithSeed var2, PublicKey var3, PublicKey var4, StakeAuthorize var5, PublicKey var6);

    public Instruction initializeStakeAccount(PublicKey var1, PublicKey var2, PublicKey var3, LockUp var4);

    default public Instruction initializeStakeAccount(PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer) {
        return this.initializeStakeAccount(unInitializedStakeAccount, staker, withdrawer, LockUp.NO_LOCKUP);
    }

    public Instruction initializeStakeAccountChecked(PublicKey var1, PublicKey var2, PublicKey var3);

    public Instruction delegateStakeAccount(PublicKey var1, PublicKey var2, PublicKey var3);

    default public Instruction delegateStakeAccount(StakeAccount initializedStakeAccount, PublicKey validatorVoteAccount) {
        return this.delegateStakeAccount(initializedStakeAccount.address(), validatorVoteAccount, initializedStakeAccount.stakeAuthority());
    }

    public Instruction reDelegateStakeAccount(StakeAccount var1, PublicKey var2, PublicKey var3);

    public Instruction splitStakeAccount(StakeAccount var1, PublicKey var2, long var3);

    public Instruction mergeStakeAccounts(StakeAccount var1, PublicKey var2);

    default public Instruction mergeStakeAccounts(StakeAccount destinationStakeAccount, StakeAccount srcStakeAccount) {
        return this.mergeStakeAccounts(destinationStakeAccount, srcStakeAccount.address());
    }

    default public List<Instruction> mergeStakeAccountKeysInto(StakeAccount destinationStakeAccount, Collection<PublicKey> stakeAccounts) {
        return stakeAccounts.stream().map(stakeAccount -> this.mergeStakeAccounts(destinationStakeAccount, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccountsInto(StakeAccount destinationStakeAccount, Collection<StakeAccount> stakeAccounts) {
        return stakeAccounts.stream().map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(destinationStakeAccount, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccountInfosInto(StakeAccount destinationStakeAccount, Collection<AccountInfo<StakeAccount>> stakeAccounts) {
        return stakeAccounts.stream().map(AccountInfo::data).map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(destinationStakeAccount, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccounts(List<StakeAccount> stakeAccounts) {
        if (stakeAccounts.size() < 2) {
            return List.of();
        }
        StakeAccount mergeInto = stakeAccounts.getFirst();
        return stakeAccounts.stream().skip(1L).map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(mergeInto, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccountInfos(List<AccountInfo<StakeAccount>> stakeAccounts) {
        if (stakeAccounts.size() < 2) {
            return List.of();
        }
        StakeAccount mergeInto = (StakeAccount)stakeAccounts.getFirst().data();
        return stakeAccounts.stream().skip(1L).map(AccountInfo::data).map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(mergeInto, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccounts(Collection<StakeAccount> stakeAccounts) {
        if (stakeAccounts.size() < 2) {
            return List.of();
        }
        StakeAccount[] array = (StakeAccount[])stakeAccounts.toArray(StakeAccount[]::new);
        StakeAccount mergeInto = array[0];
        return Arrays.stream(array, 1, array.length).map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(mergeInto, (PublicKey)stakeAccount)).toList();
    }

    default public List<Instruction> mergeStakeAccountInfos(Collection<AccountInfo<StakeAccount>> stakeAccounts) {
        AccountInfo[] array = (AccountInfo[])stakeAccounts.toArray(AccountInfo[]::new);
        StakeAccount mergeInto = (StakeAccount)array[0].data();
        return Arrays.stream(array, 1, array.length).map(AccountInfo::data).map(StakeAccount::address).map(stakeAccount -> this.mergeStakeAccounts(mergeInto, (PublicKey)stakeAccount)).toList();
    }

    public Instruction withdrawStakeAccount(StakeAccount var1, PublicKey var2, long var3);

    public Instruction deactivateStakeAccount(PublicKey var1, PublicKey var2);

    default public Instruction deactivateStakeAccount(StakeAccount delegatedStakeAccount) {
        return this.deactivateStakeAccount(delegatedStakeAccount.address(), delegatedStakeAccount.stakeAuthority());
    }

    default public List<Instruction> deactivateStakeAccountInfos(Collection<AccountInfo<StakeAccount>> delegatedStakeAccounts) {
        return delegatedStakeAccounts.stream().map(AccountInfo::data).map(this::deactivateStakeAccount).toList();
    }

    default public List<Instruction> deactivateStakeAccounts(Collection<StakeAccount> delegatedStakeAccounts) {
        return delegatedStakeAccounts.stream().map(this::deactivateStakeAccount).toList();
    }

    public Instruction moveStake(StakeAccount var1, PublicKey var2, long var3);

    public Instruction moveLamports(StakeAccount var1, PublicKey var2, long var3);
}

