/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.clients;

import java.time.Instant;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.sysvar.Clock;
import software.sava.core.rpc.Filter;
import software.sava.core.tx.Instruction;
import software.sava.rpc.json.http.client.SolanaRpcClient;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.clients.NativeProgramAccountClient;
import software.sava.solana.programs.clients.NativeProgramAccountClientImpl;
import software.sava.solana.programs.clients.NativeProgramClient;
import software.sava.solana.programs.compute_budget.ComputeBudgetProgram;
import software.sava.solana.programs.stake.LockUp;
import software.sava.solana.programs.stake.StakeAccount;
import software.sava.solana.programs.stake.StakeAuthorize;
import software.sava.solana.programs.stake.StakeProgram;
import software.sava.solana.programs.stake.StakeState;
import software.sava.solana.programs.system.SystemProgram;
import software.sava.solana.programs.token.TokenProgram;

record NativeProgramClientImpl(SolanaAccounts accounts) implements NativeProgramClient
{
    @Override
    public NativeProgramAccountClient createAccountClient(AccountMeta ownerAndFeePayer) {
        return new NativeProgramAccountClientImpl(this, ownerAndFeePayer.publicKey(), ownerAndFeePayer);
    }

    @Override
    public NativeProgramAccountClient createAccountClient(PublicKey owner, AccountMeta feePayer) {
        return new NativeProgramAccountClientImpl(this, owner, feePayer);
    }

    @Override
    public CompletableFuture<AccountInfo<Clock>> fetchClockSysVar(SolanaRpcClient rpcClient) {
        return rpcClient.getAccountInfo(this.accounts.clockSysVar(), Clock.FACTORY);
    }

    @Override
    public Instruction computeUnitLimit(int computeUnitLimit) {
        return ComputeBudgetProgram.setComputeUnitLimit(this.accounts.invokedComputeBudgetProgram(), computeUnitLimit);
    }

    @Override
    public Instruction computeUnitPrice(long computeUnitPrice) {
        return ComputeBudgetProgram.setComputeUnitPrice(this.accounts.invokedComputeBudgetProgram(), computeUnitPrice);
    }

    @Override
    public Instruction allocateAccountSpace(PublicKey newAccountPublicKey, long space) {
        return SystemProgram.allocate(this.accounts.invokedSystemProgram(), newAccountPublicKey, space);
    }

    @Override
    public Instruction syncNative(PublicKey tokenAccount) {
        return TokenProgram.syncNative(this.accounts.invokedTokenProgram(), tokenAccount);
    }

    private CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccounts(SolanaRpcClient rpcClient, List<Filter> filters) {
        return rpcClient.getProgramAccounts(this.accounts.stakeProgram(), filters, StakeAccount.FACTORY);
    }

    private CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccounts(SolanaRpcClient rpcClient, PublicKey key, int offset) {
        return this.fetchStakeAccounts(rpcClient, List.of(StakeAccount.DATA_SIZE_FILTER, Filter.createMemCompFilter((int)offset, (PublicKey)key)));
    }

    private CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccounts(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey key, int offset) {
        if (stakeState == null) {
            return this.fetchStakeAccounts(rpcClient, key, offset);
        }
        return this.fetchStakeAccounts(rpcClient, List.of(StakeAccount.DATA_SIZE_FILTER, StakeAccount.createStateFilter(stakeState), Filter.createMemCompFilter((int)offset, (PublicKey)key)));
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAuthority(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey staker) {
        return this.fetchStakeAccounts(rpcClient, stakeState, staker, 12);
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByWithdrawAuthority(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey withdrawer) {
        return this.fetchStakeAccounts(rpcClient, stakeState, withdrawer, 44);
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsByStakeAndWithdrawAuthority(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey withdrawAuthority) {
        return this.fetchStakeAccounts(rpcClient, List.of(StakeAccount.DATA_SIZE_FILTER, StakeAccount.createStateFilter(stakeState), Filter.createMemCompFilter((int)12, (PublicKey)withdrawAuthority, (PublicKey)withdrawAuthority)));
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsWithCustodian(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey custodian) {
        return this.fetchStakeAccounts(rpcClient, stakeState, custodian, 92);
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidator(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey voteAccount) {
        return this.fetchStakeAccounts(rpcClient, stakeState, voteAccount, 124);
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndWithdrawAuthority(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey voteAccount, PublicKey withdrawAuthority) {
        return this.fetchStakeAccounts(rpcClient, List.of(StakeAccount.DATA_SIZE_FILTER, StakeAccount.createStateFilter(stakeState), Filter.createMemCompFilter((int)44, (PublicKey)withdrawAuthority), Filter.createMemCompFilter((int)124, (PublicKey)voteAccount)));
    }

    @Override
    public CompletableFuture<List<AccountInfo<StakeAccount>>> fetchStakeAccountsForValidatorAndStakeAndWithdrawAuthority(SolanaRpcClient rpcClient, StakeState stakeState, PublicKey voteAccount, PublicKey withdrawAuthority) {
        return this.fetchStakeAccounts(rpcClient, List.of(StakeAccount.DATA_SIZE_FILTER, StakeAccount.createStateFilter(stakeState), Filter.createMemCompFilter((int)12, (PublicKey)withdrawAuthority, (PublicKey)withdrawAuthority), Filter.createMemCompFilter((int)124, (PublicKey)voteAccount)));
    }

    @Override
    public CompletableFuture<List<AccountInfo<AddressLookupTable>>> fetchLookupTableAccountsByAuthority(SolanaRpcClient rpcClient, PublicKey authority) {
        List<Filter> filters = List.of(Filter.createMemCompFilter((int)22, (PublicKey)authority));
        return rpcClient.getProgramAccounts(this.accounts.addressLookupTableProgram(), filters, AddressLookupTable.FACTORY);
    }

    @Override
    public Instruction deactivateDelinquentStake(PublicKey delegatedStakeAccount, PublicKey delinquentVoteAccount, PublicKey referenceVoteAccount) {
        return StakeProgram.deactivateDelinquent(this.accounts, delegatedStakeAccount, delinquentVoteAccount, referenceVoteAccount);
    }

    @Override
    public Instruction setStakeAccountLockup(PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, Instant timestamp, OptionalLong epoch, PublicKey custodian) {
        return StakeProgram.setLockup(this.accounts, initializedStakeAccount, lockupOrWithdrawAuthority, timestamp, epoch, custodian);
    }

    @Override
    public Instruction setStakeAccountLockupChecked(PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, PublicKey newLockupAuthority, Instant timestamp, OptionalLong epoch) {
        return StakeProgram.setLockupChecked(this.accounts, initializedStakeAccount, lockupOrWithdrawAuthority, newLockupAuthority, timestamp, epoch);
    }

    @Override
    public Instruction authorizeStakeAccount(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey lockupAuthority, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        return StakeProgram.authorize(this.accounts, stakeAccount, stakeOrWithdrawAuthority, lockupAuthority, newAuthority, stakeAuthorize);
    }

    @Override
    public Instruction authorizeStakeAccountChecked(PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newStakeOrWithdrawAuthority, PublicKey lockupAuthority, StakeAuthorize stakeAuthorize) {
        return StakeProgram.authorizeChecked(this.accounts, stakeAccount, stakeOrWithdrawAuthority, newStakeOrWithdrawAuthority, lockupAuthority, stakeAuthorize);
    }

    @Override
    public Instruction authorizeStakeAccountWithSeed(PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey lockupAuthority, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        return StakeProgram.authorizeWithSeed(this.accounts, stakeAccount, baseKeyOrWithdrawAuthority, lockupAuthority, newAuthorizedPublicKey, stakeAuthorize, authorityOwner);
    }

    @Override
    public Instruction authorizeStakeAccountCheckedWithSeed(PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey stakeOrWithdrawAuthority, PublicKey lockupAuthority, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        return StakeProgram.authorizeCheckedWithSeed(this.accounts, stakeAccount, baseKeyOrWithdrawAuthority, stakeOrWithdrawAuthority, lockupAuthority, stakeAuthorize, authorityOwner);
    }

    @Override
    public Instruction initializeStakeAccount(PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer, LockUp lockUp) {
        return StakeProgram.initialize(this.accounts, unInitializedStakeAccount, staker, withdrawer, lockUp);
    }

    @Override
    public Instruction initializeStakeAccountChecked(PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer) {
        return StakeProgram.initializeChecked(this.accounts, unInitializedStakeAccount, staker, withdrawer);
    }

    @Override
    public Instruction delegateStakeAccount(PublicKey initializedStakeAccount, PublicKey validatorVoteAccount, PublicKey stakeAuthority) {
        return StakeProgram.delegateStake(this.accounts, initializedStakeAccount, validatorVoteAccount, stakeAuthority);
    }

    @Override
    public Instruction reDelegateStakeAccount(StakeAccount delegatedStakeAccount, PublicKey uninitializedStakeAccount, PublicKey validatorVoteAccount) {
        return StakeProgram.reDelegate(this.accounts, delegatedStakeAccount.address(), uninitializedStakeAccount, validatorVoteAccount, delegatedStakeAccount.stakeAuthority());
    }

    @Override
    public Instruction splitStakeAccount(StakeAccount splitStakeAccount, PublicKey unInitializedStakeAccount, long lamports) {
        return StakeProgram.split(this.accounts, splitStakeAccount.address(), unInitializedStakeAccount, splitStakeAccount.stakeAuthority(), lamports);
    }

    @Override
    public Instruction mergeStakeAccounts(StakeAccount destinationStakeAccount, PublicKey srcStakeAccount) {
        return StakeProgram.merge(this.accounts, destinationStakeAccount.address(), srcStakeAccount, destinationStakeAccount.stakeAuthority());
    }

    @Override
    public Instruction withdrawStakeAccount(StakeAccount stakeAccount, PublicKey recipient, long lamports) {
        LockUp lockup = stakeAccount.lockup();
        if (lockup == null || lockup.equals(LockUp.NO_LOCKUP)) {
            return StakeProgram.withdraw(this.accounts, stakeAccount.address(), recipient, stakeAccount.withdrawAuthority(), lamports);
        }
        return StakeProgram.withdraw(this.accounts, stakeAccount.address(), recipient, stakeAccount.withdrawAuthority(), lockup.custodian(), lamports);
    }

    @Override
    public Instruction deactivateStakeAccount(PublicKey delegatedStakeAccount, PublicKey stakeAuthority) {
        return StakeProgram.deactivate(this.accounts, delegatedStakeAccount, stakeAuthority);
    }

    @Override
    public Instruction moveStake(StakeAccount sourceStakeAccount, PublicKey destinationStakeAccount, long lamports) {
        return StakeProgram.moveStake(this.accounts, sourceStakeAccount.address(), destinationStakeAccount, sourceStakeAccount.stakeAuthority(), lamports);
    }

    @Override
    public Instruction moveLamports(StakeAccount sourceStakeAccount, PublicKey destinationStakeAccount, long lamports) {
        return StakeProgram.moveLamports(this.accounts, sourceStakeAccount.address(), destinationStakeAccount, sourceStakeAccount.stakeAuthority(), lamports);
    }
}

