/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.compute_budget;

import java.util.List;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;

public final class ComputeBudgetProgram {
    public static int CU_LIMIT_CONSUMPTION = 150;
    public static int CU_PRICE_CONSUMPTION = 150;
    public static int COMPUTE_UNITS_CONSUMED = CU_LIMIT_CONSUMPTION + CU_PRICE_CONSUMPTION;
    public static int SET_LOADED_ACCOUNT_SIZE_LIMIT_CONSUMPTION = 150;
    public static int MAX_COMPUTE_BUDGET = 1400000;

    public static Instruction requestHeapFrame(AccountMeta invokedProgram, int heapRegionSize) {
        byte[] data = new byte[5];
        data[0] = Instructions.RequestHeapFrame.discriminator;
        ByteUtil.putInt32LE((byte[])data, (int)1, (int)heapRegionSize);
        return Instruction.createInstruction((AccountMeta)invokedProgram, (List)AccountMeta.NO_KEYS, (byte[])data);
    }

    public static Instruction setComputeUnitLimit(AccountMeta invokedProgram, int units) {
        byte[] data = new byte[5];
        data[0] = Instructions.SetComputeUnitLimit.discriminator;
        ByteUtil.putInt32LE((byte[])data, (int)1, (int)units);
        return Instruction.createInstruction((AccountMeta)invokedProgram, (List)AccountMeta.NO_KEYS, (byte[])data);
    }

    public static Instruction setComputeUnitPrice(AccountMeta invokedProgram, long microLamports) {
        byte[] data = new byte[9];
        data[0] = Instructions.SetComputeUnitPrice.discriminator;
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)microLamports);
        return Instruction.createInstruction((AccountMeta)invokedProgram, (List)AccountMeta.NO_KEYS, (byte[])data);
    }

    public static Instruction setLoadedAccountsDataSizeLimit(AccountMeta invokedProgram, int limit) {
        byte[] data = new byte[5];
        data[0] = Instructions.SetLoadedAccountsDataSizeLimit.discriminator;
        ByteUtil.putInt32LE((byte[])data, (int)1, (int)limit);
        return Instruction.createInstruction((AccountMeta)invokedProgram, (List)AccountMeta.NO_KEYS, (byte[])data);
    }

    private ComputeBudgetProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        Unused,
        RequestHeapFrame,
        SetComputeUnitLimit,
        SetComputeUnitPrice,
        SetLoadedAccountsDataSizeLimit;

        private final byte discriminator = (byte)this.ordinal();
        private final byte[] discriminatorBytes = new byte[]{this.discriminator};

        public byte[] data() {
            return this.discriminatorBytes;
        }

        public int write(byte[] bytes, int i) {
            bytes[i] = (byte)this.ordinal();
            return 1;
        }

        public int length() {
            return 1;
        }
    }
}

