/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.memo;

import java.util.List;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.tx.Instruction;

public final class MemoProgram {
    public static Instruction createMemoFromAccounts(AccountMeta invokedMemoProgram, List<AccountMeta> signers, byte[] memo) {
        return Instruction.createInstruction((AccountMeta)invokedMemoProgram, signers, (byte[])memo);
    }

    public static Instruction createMemoFromAccounts(SolanaAccounts solanaAccounts, List<AccountMeta> signers, byte[] memo) {
        return MemoProgram.createMemoFromAccounts(solanaAccounts.invokedMemoProgramV2(), signers, memo);
    }

    public static Instruction createMemo(AccountMeta invokedMemoProgram, List<PublicKey> signers, byte[] memo) {
        return MemoProgram.createMemoFromAccounts(invokedMemoProgram, signers.stream().map(AccountMeta::createReadOnlySigner).toList(), memo);
    }

    public static Instruction createMemo(SolanaAccounts solanaAccounts, List<PublicKey> signers, byte[] memo) {
        return MemoProgram.createMemo(solanaAccounts.invokedMemoProgramV2(), signers, memo);
    }

    private MemoProgram() {
    }
}

