/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.serde;

import java.time.Instant;
import software.sava.core.encoding.ByteUtil;

public final class SerdeUtil {
    private SerdeUtil() {
    }

    public static int writeString(byte[] utf8, byte[] data, int offset) {
        ByteUtil.putInt64LE((byte[])data, (int)offset, (long)utf8.length);
        System.arraycopy(utf8, 0, data, offset + 8, utf8.length);
        return 8 + utf8.length;
    }

    public static byte[] readString(byte[] data, int offset) {
        int length = (int)ByteUtil.getInt64LE((byte[])data, (int)offset);
        byte[] str = new byte[length];
        System.arraycopy(data, offset + 8, str, 0, length);
        return str;
    }

    public static int writeOptionalEpochSeconds(Instant timestamp, byte[] data, int offset) {
        if (timestamp == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt64LE((byte[])data, (int)(offset + 1), (long)timestamp.getEpochSecond());
        return 9;
    }

    public static byte[] readDiscriminator(byte[] data, int offset) {
        byte[] discriminator = new byte[4];
        System.arraycopy(data, offset, discriminator, 0, 4);
        return discriminator;
    }
}

