/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stake;

import java.util.Objects;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;

public record LockUp(long unixTimestamp, long epoch, PublicKey custodian) implements Borsh
{
    public static final int BYTES = 48;
    public static final LockUp NO_LOCKUP = new LockUp(0L, 0L, PublicKey.NONE);

    public static LockUp read(byte[] data, int offset) {
        long unixTimestamp = ByteUtil.getInt64LE((byte[])data, (int)offset);
        long epoch = ByteUtil.getInt64LE((byte[])data, (int)(offset + 8));
        PublicKey custodian = PublicKey.readPubKey((byte[])data, (int)(offset + 8 + 8));
        return new LockUp(unixTimestamp, epoch, custodian);
    }

    public int l() {
        return 48;
    }

    public int write(byte[] data, int offset) {
        ByteUtil.putInt64LE((byte[])data, (int)offset, (long)this.unixTimestamp);
        ByteUtil.putInt64LE((byte[])data, (int)(offset + 8), (long)this.unixTimestamp);
        Objects.requireNonNullElse(this.custodian, PublicKey.NONE).write(data, offset + 8 + 8);
        return 48;
    }
}

