/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stake;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.rpc.Filter;
import software.sava.solana.programs.stake.LockUp;
import software.sava.solana.programs.stake.StakeState;

public record StakeAccount(PublicKey address, StakeState state, long rentExemptReserve, PublicKey stakeAuthority, PublicKey withdrawAuthority, LockUp lockup, PublicKey voterPublicKey, long stake, long activationEpoch, long deActivationEpoch, double warmupCoolDownRate, long creditsObserved, byte stakeFlags) {
    public static final int BYTES = 200;
    public static final Filter DATA_SIZE_FILTER = Filter.createDataSizeFilter((int)200);
    public static final int STATE_OFFSET = 0;
    public static final int RENT_EXEMPT_RESERVE_OFFSET = 4;
    public static final int STAKE_AUTHORITY_OFFSET = 12;
    public static final int WITHDRAW_AUTHORITY_OFFSET = 44;
    public static final int LOCKUP_OFFSET = 76;
    public static final int LOCKUP_TIMESTAMP_OFFSET = 76;
    public static final int LOCKUP_EPOCH_OFFSET = 84;
    public static final int LOCKUP_CUSTODIAN_OFFSET = 92;
    public static final int VOTER_PUBLIC_KEY_OFFSET = 124;
    public static final int STAKE_OFFSET = 156;
    public static final int ACTIVATION_EPOCH_OFFSET = 164;
    public static final int DE_ACTIVATION_EPOCH_OFFSET = 172;
    public static final int WARMUP_COOLDOWN_RATE_OFFSET = 180;
    public static final int CREDITS_OBSERVED_OFFSET = 188;
    public static final int STAKE_FLAGS_OFFSET = 196;
    public static final int MUST_FULLY_ACTIVATE_BEFORE_DEACTIVATION_IS_PERMITTED = 1;
    public static final BiFunction<PublicKey, byte[], StakeAccount> FACTORY = StakeAccount::read;

    public State state(long currentEpoch) {
        if (this.deActivationEpoch < 0L) {
            return this.activationEpoch > 0L && this.activationEpoch < currentEpoch ? State.ACTIVE : State.ACTIVATING;
        }
        return this.deActivationEpoch < currentEpoch ? State.INACTIVE : State.DE_ACTIVATING;
    }

    public static Filter createStateFilter(StakeState state) {
        byte[] stateBytes = new byte[4];
        ByteUtil.putInt32LE((byte[])stateBytes, (int)0, (int)state.ordinal());
        return Filter.createMemCompFilter((int)0, (byte[])stateBytes);
    }

    public static Filter createStakeAuthorityFilter(PublicKey stakeAuthority) {
        return Filter.createMemCompFilter((int)12, (PublicKey)stakeAuthority);
    }

    public static Filter createWithdrawAuthorityFilter(PublicKey stakeAuthority) {
        return Filter.createMemCompFilter((int)44, (PublicKey)stakeAuthority);
    }

    public static Filter createCustodianFilter(PublicKey custodian) {
        return Filter.createMemCompFilter((int)92, (PublicKey)custodian);
    }

    public static Filter createVoterFilter(PublicKey voterPublicKey) {
        return Filter.createMemCompFilter((int)124, (PublicKey)voterPublicKey);
    }

    public boolean isSet(int mask) {
        return (this.stakeFlags & mask) == mask;
    }

    public static StakeAccount read(byte[] data, int offset) {
        return StakeAccount.read(null, data, offset);
    }

    public static StakeAccount read(PublicKey address, byte[] data) {
        return StakeAccount.read(address, data, 0);
    }

    public static StakeAccount read(PublicKey address, byte[] data, int offset) {
        StakeState stakeState = StakeState.values()[ByteUtil.getInt32LE((byte[])data, (int)offset)];
        long rentExemptReserve = ByteUtil.getInt64LE((byte[])data, (int)(offset += 4));
        PublicKey stakeAuthority = PublicKey.readPubKey((byte[])data, (int)(offset += 8));
        PublicKey withdrawAuthority = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        LockUp lockup = LockUp.read(data, offset += 32);
        PublicKey voterPublicKey = PublicKey.readPubKey((byte[])data, (int)(offset += 48));
        long stake = ByteUtil.getInt64LE((byte[])data, (int)(offset += 32));
        long activationEpoch = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        long deActivationEpoch = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        double warmupCooldownRate = ByteUtil.getFloat64LE((byte[])data, (int)(offset += 8));
        long creditsObserved = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        byte stakeFlags = data[offset += 8];
        return new StakeAccount(address, stakeState, rentExemptReserve, stakeAuthority, withdrawAuthority, lockup, voterPublicKey, stake, activationEpoch, deActivationEpoch, warmupCooldownRate, creditsObserved, stakeFlags);
    }

    public static enum State {
        ACTIVATING,
        ACTIVE,
        DE_ACTIVATING,
        INACTIVE;

    }
}

