/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stake;

import java.time.Instant;
import java.util.List;
import java.util.OptionalLong;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.serde.SerdeUtil;
import software.sava.solana.programs.stake.LockUp;
import software.sava.solana.programs.stake.StakeAuthorize;

public final class StakeProgram {
    public static Instruction initialize(SolanaAccounts solanaAccounts, PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer) {
        return StakeProgram.initialize(solanaAccounts, unInitializedStakeAccount, staker, withdrawer, LockUp.NO_LOCKUP);
    }

    public static Instruction initialize(SolanaAccounts solanaAccounts, PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer, LockUp lockUp) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)unInitializedStakeAccount), solanaAccounts.readRentSysVar());
        byte[] data = new byte[116];
        int i = Instructions.Initialize.write(data);
        i += staker.write(data, i);
        i += withdrawer.write(data, i);
        lockUp.write(data, i);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction initializeChecked(SolanaAccounts solanaAccounts, PublicKey unInitializedStakeAccount, PublicKey staker, PublicKey withdrawer) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)unInitializedStakeAccount), solanaAccounts.readRentSysVar(), AccountMeta.createRead((PublicKey)staker), AccountMeta.createReadOnlySigner((PublicKey)withdrawer));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.InitializeChecked.data);
    }

    public static Instruction authorize(SolanaAccounts solanaAccounts, List<AccountMeta> keys, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        byte[] data = new byte[36 + stakeAuthorize.l()];
        Instructions.Authorize.write(data);
        newAuthority.write(data, 4);
        stakeAuthorize.write(data, 36);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction authorize(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority));
        return StakeProgram.authorize(solanaAccounts, keys, newAuthority, stakeAuthorize);
    }

    public static Instruction authorize(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey lockupAuthority, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        if (lockupAuthority == null) {
            return StakeProgram.authorize(solanaAccounts, stakeAccount, stakeOrWithdrawAuthority, newAuthority, stakeAuthorize);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)lockupAuthority));
        return StakeProgram.authorize(solanaAccounts, keys, newAuthority, stakeAuthorize);
    }

    public static Instruction authorizeChecked(SolanaAccounts solanaAccounts, List<AccountMeta> keys, StakeAuthorize stakeAuthorize) {
        byte[] data = new byte[4 + stakeAuthorize.l()];
        Instructions.AuthorizeChecked.write(data);
        stakeAuthorize.write(data, 4);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeChecked(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newStakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)newStakeOrWithdrawAuthority));
        return StakeProgram.authorizeChecked(solanaAccounts, keys, stakeAuthorize);
    }

    public static Instruction authorizeChecked(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey stakeOrWithdrawAuthority, PublicKey newStakeOrWithdrawAuthority, PublicKey lockupAuthority, StakeAuthorize stakeAuthorize) {
        if (lockupAuthority == null) {
            return StakeProgram.authorizeChecked(solanaAccounts, stakeAccount, stakeOrWithdrawAuthority, newStakeOrWithdrawAuthority, stakeAuthorize);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)newStakeOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)lockupAuthority));
        return StakeProgram.authorizeChecked(solanaAccounts, keys, stakeAuthorize);
    }

    private static Instruction authorizeWithSeed(SolanaAccounts solanaAccounts, List<AccountMeta> keys, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, AccountWithSeed authoritySeed, PublicKey authorityOwner) {
        byte[] authoritySeedBytes = authoritySeed.asciiSeed();
        byte[] data = new byte[36 + stakeAuthorize.l() + (8 + authoritySeedBytes.length) + 32];
        int i = Instructions.AuthorizeWithSeed.write(data);
        i += newAuthorizedPublicKey.write(data, i);
        i += stakeAuthorize.write(data, i);
        i += SerdeUtil.writeString(authoritySeedBytes, data, i);
        authorityOwner.write(data, i);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeWithSeed(SolanaAccounts solanaAccounts, PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createReadOnlySigner((PublicKey)baseKeyOrWithdrawAuthority.publicKey()), solanaAccounts.readClockSysVar());
        return StakeProgram.authorizeWithSeed(solanaAccounts, keys, newAuthorizedPublicKey, stakeAuthorize, baseKeyOrWithdrawAuthority, authorityOwner);
    }

    public static Instruction authorizeWithSeed(SolanaAccounts solanaAccounts, PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey lockupAuthority, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        if (lockupAuthority == null) {
            return StakeProgram.authorizeWithSeed(solanaAccounts, stakeAccount, baseKeyOrWithdrawAuthority, newAuthorizedPublicKey, stakeAuthorize, authorityOwner);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createReadOnlySigner((PublicKey)baseKeyOrWithdrawAuthority.publicKey()), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)lockupAuthority));
        return StakeProgram.authorizeWithSeed(solanaAccounts, keys, newAuthorizedPublicKey, stakeAuthorize, baseKeyOrWithdrawAuthority, authorityOwner);
    }

    public static Instruction authorizeCheckedWithSeed(SolanaAccounts solanaAccounts, List<AccountMeta> keys, StakeAuthorize stakeAuthorize, AccountWithSeed authoritySeed, PublicKey authorityOwner) {
        byte[] authoritySeedBytes = authoritySeed.asciiSeed();
        byte[] data = new byte[4 + stakeAuthorize.l() + (8 + authoritySeedBytes.length) + 32];
        int i = Instructions.AuthorizeCheckedWithSeed.write(data);
        i += stakeAuthorize.write(data, i);
        i += SerdeUtil.writeString(authoritySeedBytes, data, i);
        authorityOwner.write(data, i);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeCheckedWithSeed(SolanaAccounts solanaAccounts, PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey stakeOrWithdrawAuthority, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createReadOnlySigner((PublicKey)baseKeyOrWithdrawAuthority.publicKey()), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority));
        return StakeProgram.authorizeCheckedWithSeed(solanaAccounts, keys, stakeAuthorize, baseKeyOrWithdrawAuthority, authorityOwner);
    }

    public static Instruction authorizeCheckedWithSeed(SolanaAccounts solanaAccounts, PublicKey stakeAccount, AccountWithSeed baseKeyOrWithdrawAuthority, PublicKey stakeOrWithdrawAuthority, PublicKey lockupAuthority, StakeAuthorize stakeAuthorize, PublicKey authorityOwner) {
        if (lockupAuthority == null) {
            return StakeProgram.authorizeCheckedWithSeed(solanaAccounts, stakeAccount, baseKeyOrWithdrawAuthority, stakeOrWithdrawAuthority, stakeAuthorize, authorityOwner);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createReadOnlySigner((PublicKey)baseKeyOrWithdrawAuthority.publicKey()), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)lockupAuthority));
        return StakeProgram.authorizeCheckedWithSeed(solanaAccounts, keys, stakeAuthorize, baseKeyOrWithdrawAuthority, authorityOwner);
    }

    public static Instruction delegateStake(SolanaAccounts solanaAccounts, PublicKey initializedStakeAccount, PublicKey validatorVoteAccount, PublicKey stakeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)initializedStakeAccount), AccountMeta.createRead((PublicKey)validatorVoteAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeConfig(), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.DelegateStake.data);
    }

    public static Instruction split(SolanaAccounts solanaAccounts, PublicKey splitStakeAccount, PublicKey unInitializedStakeAccount, PublicKey stakeAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)splitStakeAccount), AccountMeta.createWrite((PublicKey)unInitializedStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        byte[] data = new byte[12];
        Instructions.Split.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction withdraw(SolanaAccounts solanaAccounts, List<AccountMeta> keys, long lamports) {
        byte[] data = new byte[12];
        Instructions.Withdraw.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction withdraw(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey recipient, PublicKey withdrawAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createWrite((PublicKey)recipient), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), AccountMeta.createReadOnlySigner((PublicKey)withdrawAuthority));
        return StakeProgram.withdraw(solanaAccounts, keys, lamports);
    }

    public static Instruction withdraw(SolanaAccounts solanaAccounts, PublicKey stakeAccount, PublicKey recipient, PublicKey withdrawAuthority, PublicKey lockupAuthority, long lamports) {
        if (lockupAuthority == null) {
            return StakeProgram.withdraw(solanaAccounts, stakeAccount, recipient, withdrawAuthority, lamports);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createWrite((PublicKey)recipient), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), AccountMeta.createReadOnlySigner((PublicKey)withdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)lockupAuthority));
        return StakeProgram.withdraw(solanaAccounts, keys, lamports);
    }

    public static Instruction deactivate(SolanaAccounts solanaAccounts, PublicKey delegatedStakeAccount, PublicKey stakeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)delegatedStakeAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.Deactivate.data);
    }

    public static Instruction setLockup(SolanaAccounts solanaAccounts, PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, Instant timestamp, OptionalLong epoch, PublicKey custodian) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)initializedStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)lockupOrWithdrawAuthority));
        byte[] data = new byte[4 + (timestamp == null ? 1 : 9) + (epoch.isEmpty() ? 1 : 9) + (custodian == null ? 1 : 33)];
        int i = Instructions.SetLockup.write(data);
        i += SerdeUtil.writeOptionalEpochSeconds(timestamp, data, i);
        i += Borsh.writeOptional((OptionalLong)epoch, (byte[])data, (int)i);
        Borsh.writeOptional((PublicKey)custodian, (byte[])data, (int)i);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction setLockupChecked(SolanaAccounts solanaAccounts, List<AccountMeta> keys, Instant timestamp, OptionalLong epoch) {
        byte[] data = new byte[4 + (timestamp == null ? 1 : 9) + (epoch.isEmpty() ? 1 : 9)];
        int i = Instructions.SetLockupChecked.write(data);
        i += SerdeUtil.writeOptionalEpochSeconds(timestamp, data, i);
        Borsh.writeOptional((OptionalLong)epoch, (byte[])data, (int)i);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction setLockupChecked(SolanaAccounts solanaAccounts, PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, Instant timestamp, OptionalLong epoch) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)initializedStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)lockupOrWithdrawAuthority));
        return StakeProgram.setLockupChecked(solanaAccounts, keys, timestamp, epoch);
    }

    public static Instruction setLockupChecked(SolanaAccounts solanaAccounts, PublicKey initializedStakeAccount, PublicKey lockupOrWithdrawAuthority, PublicKey newLockupAuthority, Instant timestamp, OptionalLong epoch) {
        if (newLockupAuthority == null) {
            return StakeProgram.setLockupChecked(solanaAccounts, initializedStakeAccount, lockupOrWithdrawAuthority, timestamp, epoch);
        }
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)initializedStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)lockupOrWithdrawAuthority), AccountMeta.createReadOnlySigner((PublicKey)newLockupAuthority));
        return StakeProgram.setLockupChecked(solanaAccounts, keys, timestamp, epoch);
    }

    public static Instruction merge(SolanaAccounts solanaAccounts, PublicKey destinationStakeAccount, PublicKey srcStakeAccount, PublicKey stakeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)destinationStakeAccount), AccountMeta.createWrite((PublicKey)srcStakeAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.Merge.data);
    }

    public static Instruction deactivateDelinquent(SolanaAccounts solanaAccounts, PublicKey delegatedStakeAccount, PublicKey delinquentVoteAccount, PublicKey referenceVoteAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)delegatedStakeAccount), AccountMeta.createRead((PublicKey)delinquentVoteAccount), AccountMeta.createRead((PublicKey)referenceVoteAccount));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.DeactivateDelinquent.data);
    }

    public static Instruction reDelegate(SolanaAccounts solanaAccounts, PublicKey delegatedStakeAccount, PublicKey uninitializedStakeAccount, PublicKey validatorVoteAccount, PublicKey stakeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)delegatedStakeAccount), AccountMeta.createWrite((PublicKey)uninitializedStakeAccount), AccountMeta.createRead((PublicKey)validatorVoteAccount), solanaAccounts.readStakeConfig(), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])Instructions.Redelegate.data);
    }

    public static Instruction moveStake(SolanaAccounts solanaAccounts, PublicKey sourceStakeAccount, PublicKey destinationStakeAccount, PublicKey stakeAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)sourceStakeAccount), AccountMeta.createWrite((PublicKey)destinationStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        byte[] data = new byte[12];
        Instructions.MoveStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    public static Instruction moveLamports(SolanaAccounts solanaAccounts, PublicKey sourceStakeAccount, PublicKey destinationStakeAccount, PublicKey stakeAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)sourceStakeAccount), AccountMeta.createWrite((PublicKey)destinationStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)stakeAuthority));
        byte[] data = new byte[12];
        Instructions.MoveLamports.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedStakeProgram(), keys, (byte[])data);
    }

    private StakeProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        Initialize,
        Authorize,
        DelegateStake,
        Split,
        Withdraw,
        Deactivate,
        SetLockup,
        Merge,
        AuthorizeWithSeed,
        InitializeChecked,
        AuthorizeChecked,
        AuthorizeCheckedWithSeed,
        SetLockupChecked,
        GetMinimumDelegation,
        DeactivateDelinquent,
        Redelegate,
        MoveStake,
        MoveLamports;

        private final byte[] data = Discriminator.serializeDiscriminator((Enum)this);

        public byte[] data() {
            return this.data;
        }
    }

    public record MoveLamports(byte[] discriminator, long lamports) {
        public static MoveLamports read(Instruction instruction) {
            return MoveLamports.read(instruction.data(), instruction.offset());
        }

        public static MoveLamports read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length));
            return new MoveLamports(discriminator, lamports);
        }
    }

    public record MoveStake(byte[] discriminator, long lamports) {
        public static MoveStake read(Instruction instruction) {
            return MoveStake.read(instruction.data(), instruction.offset());
        }

        public static MoveStake read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length));
            return new MoveStake(discriminator, lamports);
        }
    }

    public record SetLockupChecked(byte[] discriminator, Instant timestamp, OptionalLong epoch) {
        public static SetLockupChecked read(Instruction instruction) {
            return SetLockupChecked.read(instruction.data(), instruction.offset());
        }

        public static SetLockupChecked read(byte[] data, int offset) {
            Instant timestamp;
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            if (data[i++] == 1) {
                timestamp = Instant.ofEpochSecond(ByteUtil.getInt64LE((byte[])data, (int)i));
                i += 8;
            } else {
                timestamp = null;
            }
            OptionalLong epoch = data[i++] == 1 ? OptionalLong.of(ByteUtil.getInt64LE((byte[])data, (int)i)) : OptionalLong.empty();
            return new SetLockupChecked(discriminator, timestamp, epoch);
        }
    }

    public record SetLockup(byte[] discriminator, Instant timestamp, OptionalLong epoch, PublicKey custodian) {
        public static SetLockup read(Instruction instruction) {
            return SetLockup.read(instruction.data(), instruction.offset());
        }

        public static SetLockup read(byte[] data, int offset) {
            OptionalLong epoch;
            Instant timestamp;
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            if (data[i++] == 1) {
                timestamp = Instant.ofEpochSecond(ByteUtil.getInt64LE((byte[])data, (int)i));
                i += 8;
            } else {
                timestamp = null;
            }
            if (data[i++] == 1) {
                epoch = OptionalLong.of(ByteUtil.getInt64LE((byte[])data, (int)i));
                i += 8;
            } else {
                epoch = OptionalLong.empty();
            }
            PublicKey custodian = data[i++] == 1 ? PublicKey.readPubKey((byte[])data, (int)i) : null;
            return new SetLockup(discriminator, timestamp, epoch, custodian);
        }
    }

    public record Withdraw(byte[] discriminator, long lamports) {
        public static Withdraw read(Instruction instruction) {
            return Withdraw.read(instruction.data(), instruction.offset());
        }

        public static Withdraw read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length));
            return new Withdraw(discriminator, lamports);
        }
    }

    public record Split(byte[] discriminator, long lamports) {
        public static Split read(Instruction instruction) {
            return Split.read(instruction.data(), instruction.offset());
        }

        public static Split read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length));
            return new Split(discriminator, lamports);
        }
    }

    public record AuthorizeCheckedWithSeed(byte[] discriminator, StakeAuthorize stakeAuthorize, byte[] seed, PublicKey authorityOwner) {
        public static AuthorizeCheckedWithSeed read(Instruction instruction) {
            return AuthorizeCheckedWithSeed.read(instruction.data(), instruction.offset());
        }

        public static AuthorizeCheckedWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            StakeAuthorize stakeAuthorize = StakeAuthorize.read(data, i);
            byte[] seed = SerdeUtil.readString(data, i += stakeAuthorize.l());
            PublicKey authorityOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8 + seed.length));
            return new AuthorizeCheckedWithSeed(discriminator, stakeAuthorize, seed, authorityOwner);
        }
    }

    public record AuthorizeWithSeed(byte[] discriminator, PublicKey newAuthorizedPublicKey, StakeAuthorize stakeAuthorize, byte[] seed, PublicKey authorityOwner) {
        public static AuthorizeWithSeed read(Instruction instruction) {
            return AuthorizeWithSeed.read(instruction.data(), instruction.offset());
        }

        public static AuthorizeWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey newAuthorizedPublicKey = PublicKey.readPubKey((byte[])data, (int)i);
            StakeAuthorize stakeAuthorize = StakeAuthorize.read(data, i += 32);
            byte[] seed = SerdeUtil.readString(data, i += stakeAuthorize.l());
            PublicKey authorityOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8 + seed.length));
            return new AuthorizeWithSeed(discriminator, newAuthorizedPublicKey, stakeAuthorize, seed, authorityOwner);
        }
    }

    public record AuthorizeChecked(byte[] discriminator, StakeAuthorize stakeAuthorize) {
        public static AuthorizeChecked read(Instruction instruction) {
            return AuthorizeChecked.read(instruction.data(), instruction.offset());
        }

        public static AuthorizeChecked read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            StakeAuthorize stakeAuthorize = StakeAuthorize.read(data, offset + discriminator.length);
            return new AuthorizeChecked(discriminator, stakeAuthorize);
        }
    }

    public record Authorize(byte[] discriminator, PublicKey newAuthority, StakeAuthorize stakeAuthorize) {
        public static Authorize read(Instruction instruction) {
            return Authorize.read(instruction.data(), instruction.offset());
        }

        public static Authorize read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey newAuthority = PublicKey.readPubKey((byte[])data, (int)i);
            StakeAuthorize stakeAuthorize = StakeAuthorize.read(data, i += 32);
            return new Authorize(discriminator, newAuthority, stakeAuthorize);
        }
    }

    public record Initialize(byte[] discriminator, PublicKey staker, PublicKey withdrawer, LockUp lockUp) {
        public static Initialize read(Instruction instruction) {
            return Initialize.read(instruction.data(), instruction.offset());
        }

        public static Initialize read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey staker = PublicKey.readPubKey((byte[])data, (int)i);
            PublicKey withdrawer = PublicKey.readPubKey((byte[])data, (int)(i += 32));
            LockUp lockUp = LockUp.read(data, i += 32);
            return new Initialize(discriminator, staker, withdrawer, lockUp);
        }
    }
}

