/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stakepool;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.stakepool.FeeType;
import software.sava.solana.programs.stakepool.StakePoolState;

public final class StakePoolProgram {
    public static ProgramDerivedAddress findStakePoolWithdrawAuthority(PublicKey stakePool, PublicKey stakePoolProgram) {
        return PublicKey.findProgramAddress(List.of(stakePool.toByteArray(), "withdraw".getBytes(StandardCharsets.UTF_8)), (PublicKey)stakePoolProgram);
    }

    public static ProgramDerivedAddress findStakePoolDepositAuthority(PublicKey stakePool, PublicKey stakePoolProgram) {
        return PublicKey.findProgramAddress(List.of(stakePool.toByteArray(), "deposit".getBytes(StandardCharsets.UTF_8)), (PublicKey)stakePoolProgram);
    }

    public static Instruction initialize(AccountMeta invokedStakePoolProgram, PublicKey newStakePool, PublicKey manager, PublicKey staker, PublicKey uninitializedValidatorStakeList, PublicKey reserveStakeAccount, PublicKey poolTokenMint, PublicKey feeAccount, PublicKey tokenProgram, PublicKey depositAuthority, StakePoolState.Fee fee, StakePoolState.Fee withdrawalFee, StakePoolState.Fee depositFee, int referralFee, int maxValidators) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(newStakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)newStakePool), AccountMeta.createReadOnlySigner((PublicKey)manager), AccountMeta.createRead((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)uninitializedValidatorStakeList), AccountMeta.createRead((PublicKey)reserveStakeAccount), AccountMeta.createRead((PublicKey)poolTokenMint), AccountMeta.createRead((PublicKey)feeAccount), AccountMeta.createRead((PublicKey)tokenProgram), AccountMeta.createRead((PublicKey)depositAuthority));
        byte[] data = new byte[54];
        int i = Instructions.Initialize.write(data);
        i += fee.write(data, i);
        i += withdrawalFee.write(data, i);
        i += depositFee.write(data, i);
        data[i] = (byte)referralFee;
        ByteUtil.putInt32LE((byte[])data, (int)(++i), (int)maxValidators);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction initialize(AccountMeta invokedStakePoolProgram, PublicKey newStakePool, PublicKey manager, PublicKey staker, PublicKey uninitializedValidatorListStorageAccount, PublicKey reserveStakeAccount, PublicKey poolTokenMint, PublicKey feeAccount, PublicKey tokenProgram, StakePoolState.Fee fee, StakePoolState.Fee withdrawalFee, StakePoolState.Fee depositFee, int referralFee, int maxValidators) {
        ProgramDerivedAddress stakePoolDepositAuthority = StakePoolProgram.findStakePoolDepositAuthority(newStakePool, invokedStakePoolProgram.publicKey());
        return StakePoolProgram.initialize(invokedStakePoolProgram, newStakePool, manager, staker, uninitializedValidatorListStorageAccount, reserveStakeAccount, poolTokenMint, feeAccount, tokenProgram, stakePoolDepositAuthority.publicKey(), fee, withdrawalFee, depositFee, referralFee, maxValidators);
    }

    public static List<AccountMeta> addValidatorToPoolKeys(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey reserveStakeAccount, PublicKey validatorListStorageAccount, PublicKey stakeAccount, PublicKey validator) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        return List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createWrite((PublicKey)reserveStakeAccount), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorListStorageAccount), AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createRead((PublicKey)validator), solanaAccounts.readRentSysVar(), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeConfig(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
    }

    public static Instruction addValidatorToPool(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey reserveStakeAccount, PublicKey validatorListStorageAccount, PublicKey stakeAccount, PublicKey validator) {
        List<AccountMeta> keys = StakePoolProgram.addValidatorToPoolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, staker, reserveStakeAccount, validatorListStorageAccount, stakeAccount, validator);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])Instructions.AddValidatorToPool.data);
    }

    public static Instruction addValidatorToPool(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey reserveStakeAccount, PublicKey validatorListStorageAccount, PublicKey stakeAccount, PublicKey validator, int seed) {
        List<AccountMeta> keys = StakePoolProgram.addValidatorToPoolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, staker, reserveStakeAccount, validatorListStorageAccount, stakeAccount, validator);
        byte[] data = new byte[Instructions.AddValidatorToPool.length() + 4];
        int i = Instructions.AddValidatorToPool.write(data);
        ByteUtil.putInt32LE((byte[])data, (int)i, (int)seed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction removeValidatorFromPool(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorListStorageAccount, PublicKey stakeAccount, PublicKey transientStakeAccount) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorListStorageAccount), AccountMeta.createWrite((PublicKey)stakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeProgram());
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])Instructions.RemoveValidatorFromPool.data);
    }

    public static Instruction decreaseValidatorStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey splitFromStakeAccount, PublicKey transientStakeAccount, long lamports, long transientStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)splitFromStakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readRentSysVar(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[17];
        Instructions.DecreaseValidatorStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)9, (long)transientStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction increaseValidatorStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey stakePoolReserveAccount, PublicKey validatorStakeAccount, PublicKey validatorVoteAccount, long lamports, long transientStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)stakePoolReserveAccount), AccountMeta.createRead((PublicKey)validatorStakeAccount), AccountMeta.createRead((PublicKey)validatorVoteAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readRentSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeConfig(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[17];
        Instructions.IncreaseValidatorStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)9, (long)transientStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction setPreferredValidator(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PreferredValidatorType preferredValidatorType, PublicKey validatorVoteAddress) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)validatorList));
        byte[] data = new byte[35];
        int i = Instructions.SetPreferredValidator.write(data);
        i += preferredValidatorType.write(data, i);
        Borsh.writeOptional((PublicKey)validatorVoteAddress, (byte[])data, (int)i);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction updateValidatorListBalance(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorListStorageAccount, PublicKey reserveStakeAccount, List<PublicKey> validatorAndTransientStakeAccounts, int startIndex, boolean noMerge) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        AccountMeta[] keys = new AccountMeta[7 + validatorAndTransientStakeAccounts.size()];
        keys[0] = AccountMeta.createRead((PublicKey)stakePool);
        keys[1] = AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey());
        keys[2] = AccountMeta.createWrite((PublicKey)validatorListStorageAccount);
        keys[3] = AccountMeta.createWrite((PublicKey)reserveStakeAccount);
        keys[4] = solanaAccounts.readClockSysVar();
        keys[5] = solanaAccounts.readStakeHistorySysVar();
        keys[6] = solanaAccounts.readStakeProgram();
        int i = 7;
        for (PublicKey validatorStakeAccount : validatorAndTransientStakeAccounts) {
            keys[i++] = AccountMeta.createRead((PublicKey)validatorStakeAccount);
        }
        byte[] data = new byte[6];
        Instructions.UpdateValidatorListBalance.write(data);
        ByteUtil.putInt32LE((byte[])data, (int)1, (int)startIndex);
        data[5] = (byte)(noMerge ? 1 : 0);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction cleanupRemovedValidatorEntries(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorListStorageAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createWrite((PublicKey)validatorListStorageAccount));
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (Discriminator)Instructions.CleanupRemovedValidatorEntries);
    }

    public static Instruction setManager(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey manager, PublicKey newManager, PublicKey newManagerFeeAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)manager), AccountMeta.createReadOnlySigner((PublicKey)newManager), AccountMeta.createRead((PublicKey)newManagerFeeAccount));
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (Discriminator)Instructions.SetManager);
    }

    public static Instruction setFee(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey manager, FeeType feeType) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)manager));
        byte[] data = new byte[1 + feeType.l()];
        Instructions.SetFee.write(data);
        feeType.write(data, 1);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction setStaker(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey managerOrCurrentStaker, PublicKey newStaker) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)managerOrCurrentStaker), AccountMeta.createRead((PublicKey)newStaker));
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (Discriminator)Instructions.SetStaker);
    }

    public static Instruction setFundingAuthority(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey manager, PublicKey newAuthority, FundingType fundingType) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)manager), AccountMeta.createRead((PublicKey)newAuthority));
        byte[] data = new byte[2];
        Instructions.SetFundingAuthority.write(data);
        fundingType.write(data, 1);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    private static List<AccountMeta> createDepositSolKeys(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey reserveStakeAccount, PublicKey solDepositAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        return List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)reserveStakeAccount), AccountMeta.createReadOnlySigner((PublicKey)solDepositAuthority), AccountMeta.createWrite((PublicKey)poolTokenATA), AccountMeta.createWrite((PublicKey)poolTokenFeeATA), AccountMeta.createWrite((PublicKey)poolTokenReferralFeeATA), AccountMeta.createWrite((PublicKey)poolTokenMint), solanaAccounts.readSystemProgram(), AccountMeta.createRead((PublicKey)stakePoolTokenProgramId));
    }

    public static Instruction depositSolWithSlippage(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey reserveStakeAccount, PublicKey solDepositAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long lamportsIn, long minimumPoolTokensOut) {
        List<AccountMeta> keys = StakePoolProgram.createDepositSolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, reserveStakeAccount, solDepositAuthority, poolTokenATA, poolTokenFeeATA, poolTokenReferralFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[17];
        Instructions.DepositSolWithSlippage.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)lamportsIn);
        ByteUtil.putInt64LE((byte[])data, (int)9, (long)minimumPoolTokensOut);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction depositSol(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey reserveStakeAccount, PublicKey solDepositAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long lamportsIn) {
        List<AccountMeta> keys = StakePoolProgram.createDepositSolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, reserveStakeAccount, solDepositAuthority, poolTokenATA, poolTokenFeeATA, poolTokenReferralFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[9];
        Instructions.DepositSol.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)lamportsIn);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    private static List<AccountMeta> createDepositStakeKeys(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey stakePoolDepositAuthority, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey reserveStakeAccount, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        return List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createWrite((PublicKey)validatorStakeListStorageAccount), AccountMeta.createReadOnlySigner((PublicKey)stakePoolDepositAuthority), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)depositStakeAccount), AccountMeta.createWrite((PublicKey)validatorStakeAccount), AccountMeta.createWrite((PublicKey)reserveStakeAccount), AccountMeta.createWrite((PublicKey)poolTokenATA), AccountMeta.createWrite((PublicKey)poolTokenFeeATA), AccountMeta.createWrite((PublicKey)poolTokenReferralFeeATA), AccountMeta.createWrite((PublicKey)poolTokenMint), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), AccountMeta.createRead((PublicKey)stakePoolTokenProgramId), solanaAccounts.readStakeProgram());
    }

    public static Instruction depositStakeWithSlippage(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey stakePoolDepositAuthority, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey reserveStakeAccount, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long minimumPoolTokensOut) {
        List<AccountMeta> keys = StakePoolProgram.createDepositStakeKeys(solanaAccounts, invokedStakePoolProgram, stakePool, validatorStakeListStorageAccount, stakePoolDepositAuthority, depositStakeAccount, validatorStakeAccount, reserveStakeAccount, poolTokenATA, poolTokenFeeATA, poolTokenReferralFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[9];
        Instructions.DepositStakeWithSlippage.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)minimumPoolTokensOut);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction depositStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey stakePoolDepositAuthority, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey reserveStakeAccount, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenReferralFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        List<AccountMeta> keys = StakePoolProgram.createDepositStakeKeys(solanaAccounts, invokedStakePoolProgram, stakePool, validatorStakeListStorageAccount, stakePoolDepositAuthority, depositStakeAccount, validatorStakeAccount, reserveStakeAccount, poolTokenATA, poolTokenFeeATA, poolTokenReferralFeeATA, poolTokenMint, stakePoolTokenProgramId);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])Instructions.DepositStake.data);
    }

    private static List<AccountMeta> createWithdrawSolKeys(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey reserveStakeAccount, PublicKey receivingAccount, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        return List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createReadOnlySigner((PublicKey)transferAuthority), AccountMeta.createWrite((PublicKey)poolTokenATA), AccountMeta.createWrite((PublicKey)reserveStakeAccount), AccountMeta.createWrite((PublicKey)receivingAccount), AccountMeta.createWrite((PublicKey)poolTokenFeeATA), AccountMeta.createWrite((PublicKey)poolTokenMint), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeProgram(), AccountMeta.createRead((PublicKey)stakePoolTokenProgramId));
    }

    public static Instruction withdrawSolWithSlippage(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey reserveStakeAccount, PublicKey receivingAccount, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long poolTokenAmount, long lamportsOut) {
        List<AccountMeta> keys = StakePoolProgram.createWithdrawSolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, transferAuthority, poolTokenATA, reserveStakeAccount, receivingAccount, poolTokenFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[17];
        Instructions.WithdrawSolWithSlippage.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)poolTokenAmount);
        ByteUtil.putInt64LE((byte[])data, (int)9, (long)lamportsOut);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction withdrawSol(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey reserveStakeAccount, PublicKey receivingAccount, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long poolTokenAmount) {
        List<AccountMeta> keys = StakePoolProgram.createWithdrawSolKeys(solanaAccounts, invokedStakePoolProgram, stakePool, transferAuthority, poolTokenATA, reserveStakeAccount, receivingAccount, poolTokenFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[9];
        Instructions.WithdrawSol.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)poolTokenAmount);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    private static List<AccountMeta> createWithdrawStakeKeys(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        return List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createWrite((PublicKey)validatorStakeListStorageAccount), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorOrReserveStakeAccount), AccountMeta.createWrite((PublicKey)uninitializedStakeAccount), AccountMeta.createRead((PublicKey)stakeAccountWithdrawalAuthority), AccountMeta.createReadOnlySigner((PublicKey)transferAuthority), AccountMeta.createWrite((PublicKey)poolTokenATA), AccountMeta.createWrite((PublicKey)poolTokenFeeATA), AccountMeta.createWrite((PublicKey)poolTokenMint), solanaAccounts.readClockSysVar(), AccountMeta.createRead((PublicKey)stakePoolTokenProgramId), solanaAccounts.readStakeProgram());
    }

    public static Instruction withdrawStakeWithSlippage(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long poolTokenAmount, long lamportsOut) {
        List<AccountMeta> keys = StakePoolProgram.createWithdrawStakeKeys(solanaAccounts, invokedStakePoolProgram, stakePool, validatorStakeListStorageAccount, validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, transferAuthority, poolTokenATA, poolTokenFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[17];
        Instructions.WithdrawStakeWithSlippage.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)poolTokenAmount);
        ByteUtil.putInt64LE((byte[])data, (int)9, (long)lamportsOut);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction withdrawStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey transferAuthority, PublicKey poolTokenATA, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId, long poolTokenAmount) {
        List<AccountMeta> keys = StakePoolProgram.createWithdrawStakeKeys(solanaAccounts, invokedStakePoolProgram, stakePool, validatorStakeListStorageAccount, validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, transferAuthority, poolTokenATA, poolTokenFeeATA, poolTokenMint, stakePoolTokenProgramId);
        byte[] data = new byte[9];
        Instructions.WithdrawStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)poolTokenAmount);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction updateStakePoolBalance(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey validatorStakeListStorageAccount, PublicKey reserveStakeAccount, PublicKey poolTokenFeeATA, PublicKey poolTokenMint, PublicKey stakePoolTokenProgramId) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)stakePool), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorStakeListStorageAccount), AccountMeta.createRead((PublicKey)reserveStakeAccount), AccountMeta.createWrite((PublicKey)poolTokenFeeATA), AccountMeta.createWrite((PublicKey)poolTokenMint), AccountMeta.createRead((PublicKey)stakePoolTokenProgramId));
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])Instructions.UpdateStakePoolBalance.data);
    }

    private static byte[] metadata(Instructions metadataIx, String tokenName, String symbol, String uri) {
        byte[] tokenNameBytes = tokenName.getBytes(StandardCharsets.UTF_8);
        byte[] symbolBytes = symbol.getBytes(StandardCharsets.UTF_8);
        byte[] uriBytes = uri.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[5 + tokenNameBytes.length + 4 + symbolBytes.length + 4 + uriBytes.length];
        int i = metadataIx.write(data);
        ByteUtil.putInt32LE((byte[])data, (int)i, (int)tokenNameBytes.length);
        System.arraycopy(tokenNameBytes, 0, data, i += 4, tokenNameBytes.length);
        ByteUtil.putInt32LE((byte[])data, (int)(i += tokenNameBytes.length), (int)symbolBytes.length);
        System.arraycopy(symbolBytes, 0, data, i += 4, symbolBytes.length);
        ByteUtil.putInt32LE((byte[])data, (int)(i += symbolBytes.length), (int)uriBytes.length);
        System.arraycopy(uriBytes, 0, data, i += 4, uriBytes.length);
        return data;
    }

    public static Instruction createTokenMetadata(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey manager, PublicKey poolTokenMint, PublicKey payer, PublicKey tokenMetadataAccount, PublicKey metadataProgram, String tokenName, String symbol, String uri) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)manager), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createRead((PublicKey)poolTokenMint), AccountMeta.createWritableSigner((PublicKey)payer), AccountMeta.createWrite((PublicKey)tokenMetadataAccount), AccountMeta.createRead((PublicKey)metadataProgram), solanaAccounts.readSystemProgram());
        byte[] data = StakePoolProgram.metadata(Instructions.CreateTokenMetadata, tokenName, symbol, uri);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction updateTokenMetadata(AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey manager, PublicKey tokenMetadataAccount, PublicKey metadataProgram, String tokenName, String symbol, String uri) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)manager), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)tokenMetadataAccount), AccountMeta.createRead((PublicKey)metadataProgram));
        byte[] data = StakePoolProgram.metadata(Instructions.UpdateTokenMetadata, tokenName, symbol, uri);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction increaseAdditionalValidatorStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey stakePoolReserveStake, PublicKey uninitializedStakeAccount, PublicKey transientStakeAccount, PublicKey validatorStakeAccount, PublicKey validatorVoteAccount, long lamports, long transientStakeSeed, long ephemeralStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)stakePoolReserveStake), AccountMeta.createWrite((PublicKey)uninitializedStakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), AccountMeta.createRead((PublicKey)validatorStakeAccount), AccountMeta.createRead((PublicKey)validatorVoteAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeConfig(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[25];
        int i = Instructions.IncreaseAdditionalValidatorStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)transientStakeSeed);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)ephemeralStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction decreaseAdditionalValidatorStake(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey stakePoolReserveStake, PublicKey splitFromStakeAccount, PublicKey uninitializedStakeAccount, PublicKey transientStakeAccount, long lamports, long transientStakeSeed, long ephemeralStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)stakePoolReserveStake), AccountMeta.createWrite((PublicKey)splitFromStakeAccount), AccountMeta.createWrite((PublicKey)uninitializedStakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[25];
        int i = Instructions.DecreaseAdditionalValidatorStake.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)transientStakeSeed);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)ephemeralStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction decreaseValidatorStakeWithReserve(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey stakePoolReserveStake, PublicKey splitFromStakeAccount, PublicKey transientStakeAccount, long lamports, long transientStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)stakePoolReserveStake), AccountMeta.createWrite((PublicKey)splitFromStakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[17];
        int i = Instructions.DecreaseValidatorStakeWithReserve.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)transientStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    public static Instruction redelegate(SolanaAccounts solanaAccounts, AccountMeta invokedStakePoolProgram, PublicKey stakePool, PublicKey staker, PublicKey validatorList, PublicKey stakePoolReserveStake, PublicKey splitFromStakeAccount, PublicKey transientStakeAccount, PublicKey uninitializedStakeAccount, PublicKey ephemeralDestinationStakeAccount, PublicKey transientDestinationStakeAccount, PublicKey validatorVoteAccount, long lamports, long sourceTransientStakeSeed, long ephemeralStakeSeed, long destinationTransientStakeSeed) {
        ProgramDerivedAddress stakePoolWithdrawAuthority = StakePoolProgram.findStakePoolWithdrawAuthority(stakePool, invokedStakePoolProgram.publicKey());
        List<AccountMeta> keys = List.of(AccountMeta.createRead((PublicKey)stakePool), AccountMeta.createReadOnlySigner((PublicKey)staker), AccountMeta.createRead((PublicKey)stakePoolWithdrawAuthority.publicKey()), AccountMeta.createWrite((PublicKey)validatorList), AccountMeta.createWrite((PublicKey)stakePoolReserveStake), AccountMeta.createWrite((PublicKey)splitFromStakeAccount), AccountMeta.createWrite((PublicKey)transientStakeAccount), AccountMeta.createWrite((PublicKey)uninitializedStakeAccount), AccountMeta.createWrite((PublicKey)ephemeralDestinationStakeAccount), AccountMeta.createRead((PublicKey)transientDestinationStakeAccount), AccountMeta.createRead((PublicKey)validatorVoteAccount), solanaAccounts.readClockSysVar(), solanaAccounts.readStakeHistorySysVar(), solanaAccounts.readStakeConfig(), solanaAccounts.readSystemProgram(), solanaAccounts.readStakeProgram());
        byte[] data = new byte[33];
        int i = Instructions.Redelegate.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)sourceTransientStakeSeed);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)ephemeralStakeSeed);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)destinationTransientStakeSeed);
        return Instruction.createInstruction((AccountMeta)invokedStakePoolProgram, keys, (byte[])data);
    }

    private StakePoolProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        Initialize{}
        ,
        AddValidatorToPool,
        RemoveValidatorFromPool,
        DecreaseValidatorStake{}
        ,
        IncreaseValidatorStake{}
        ,
        SetPreferredValidator{}
        ,
        UpdateValidatorListBalance{}
        ,
        UpdateStakePoolBalance,
        CleanupRemovedValidatorEntries,
        DepositStake,
        WithdrawStake,
        SetManager,
        SetFee{}
        ,
        SetStaker,
        DepositSol,
        SetFundingAuthority,
        WithdrawSol,
        CreateTokenMetadata{}
        ,
        UpdateTokenMetadata{}
        ,
        IncreaseAdditionalValidatorStake{}
        ,
        DecreaseAdditionalValidatorStake{}
        ,
        DecreaseValidatorStakeWithReserve{}
        ,
        Redelegate{}
        ,
        DepositStakeWithSlippage{}
        ,
        WithdrawStakeWithSlippage{}
        ,
        DepositSolWithSlippage{}
        ,
        WithdrawSolWithSlippage{};

        private final byte[] data = new byte[]{(byte)this.ordinal()};

        public byte[] data() {
            return this.data;
        }

        public int write(byte[] bytes, int i) {
            bytes[i] = (byte)this.ordinal();
            return 1;
        }

        public int length() {
            return 1;
        }
    }

    public static enum PreferredValidatorType implements Borsh.Enum
    {
        Deposit,
        Withdraw;

    }

    public static enum FundingType implements Borsh.Enum
    {
        StakeDeposit,
        SolDeposit,
        SolWithdraw;

    }
}

