/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stakepool;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.solana.programs.stake.LockUp;
import software.sava.solana.programs.stakepool.AccountType;

public record StakePoolState(PublicKey address, AccountType accountType, PublicKey manager, PublicKey staker, PublicKey stakeDepositAuthority, int stakeWithdrawBumpSeed, PublicKey validatorList, PublicKey reserveStake, PublicKey poolMint, PublicKey managerFeeAccount, PublicKey tokenProgramId, BigDecimal totalLamports, BigDecimal poolTokenSupply, long lastUpdateEpoch, LockUp lockUp, Fee epochFee, FutureEpochFee nextEpochFee, PublicKey preferredDepositValidatorVoteAddress, PublicKey preferredWithdrawValidatorVoteAddress, Fee stakeDepositFee, Fee stakeWithdrawalFee, FutureEpochFee nextStakeWithdrawalFee, int stakeReferralFee, PublicKey solDepositAuthority, Fee solDepositFee, int solReferralFee, PublicKey solWithdrawAuthority, Fee solWithdrawalFee, FutureEpochFee nextSolWithdrawalFee, long lastEpochPoolTokenSupply, long lastEpochTotalLamports) {
    public static final int MANAGER_OFFSET = 1;
    public static final int STAKE_OFFSET = 33;
    public static final int STAKE_DEPOSIT_AUTHORITY_OFFSET = 65;
    public static final int STAKE_WITHDRAWAL_BUMP_SEED_OFFSET = 97;
    public static final int VALIDATOR_LIST_OFFSET = 98;
    public static final int RESERVE_STAKE_OFFSET = 130;
    public static final int POOL_MINT_OFFSET = 162;
    public static final int MANAGER_FEE_OFFSET = 194;
    public static final int TOKEN_PROGRAM_ID_OFFSET = 226;
    public static final int TOTAL_LAMPORTS_OFFSET = 258;
    public static final int POOL_TOKEN_SUPPLY_OFFSET = 266;
    public static final int LAST_UPDATE_EPOCH_OFFSET = 274;
    public static final int LOCKUP_OFFSET = 282;
    public static final int EPOCH_FEE_OFFSET = 330;
    public static final int NEXT_EPOCH_FEE_OFFSET = 346;
    public static final BiFunction<PublicKey, byte[], StakePoolState> FACTORY = StakePoolState::parseProgramData;

    public BigDecimal calculateSolPrice(MathContext mathContext) {
        return this.totalLamports.signum() == 0 || this.poolTokenSupply.signum() == 0 ? BigDecimal.ZERO : this.totalLamports.divide(this.poolTokenSupply, mathContext).stripTrailingZeros();
    }

    public BigDecimal calculateSolPrice(int scale, RoundingMode roundingMode) {
        return this.totalLamports.signum() == 0 || this.poolTokenSupply.signum() == 0 ? BigDecimal.ZERO : this.totalLamports.divide(this.poolTokenSupply, scale, roundingMode).stripTrailingZeros();
    }

    public static StakePoolState parseProgramData(byte[] data) {
        return StakePoolState.parseProgramData(null, data);
    }

    public static StakePoolState parseProgramData(PublicKey address, byte[] data) {
        PublicKey solWithdrawAuthority;
        PublicKey solDepositAuthority;
        PublicKey preferredWithdrawValidatorVoteAddress;
        PublicKey preferredDepositValidatorVoteAddress;
        AccountType accountType = AccountType.values()[data[0]];
        int offset = 1;
        PublicKey manager = PublicKey.readPubKey((byte[])data, (int)offset);
        PublicKey staker = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        PublicKey stakeDepositAuthority = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        int stakeWithdrawBumpSeed = data[offset += 32] & 0xFF;
        PublicKey validatorList = PublicKey.readPubKey((byte[])data, (int)(++offset));
        PublicKey reserveStake = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        PublicKey poolMint = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        PublicKey managerFeeAccount = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        PublicKey tokenProgramId = PublicKey.readPubKey((byte[])data, (int)(offset += 32));
        long totalLamports = ByteUtil.getInt64LE((byte[])data, (int)(offset += 32));
        long poolTokenSupply = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        long lastUpdateEpoch = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        LockUp lockUp = LockUp.read(data, offset += 8);
        Fee epochFee = Fee.parseFee(data, offset += 48);
        FutureEpochFee nextEpochFee = FutureEpochFee.parseFutureFee(data, offset += 16);
        offset = nextEpochFee == FutureEpochFee.NONE ? ++offset : (offset += 17);
        if (data[offset] == 0) {
            ++offset;
            preferredDepositValidatorVoteAddress = null;
        } else {
            preferredDepositValidatorVoteAddress = PublicKey.readPubKey((byte[])data, (int)(++offset));
            offset += 32;
        }
        if (data[offset] == 0) {
            ++offset;
            preferredWithdrawValidatorVoteAddress = null;
        } else {
            preferredWithdrawValidatorVoteAddress = PublicKey.readPubKey((byte[])data, (int)(++offset));
            offset += 32;
        }
        Fee stakeDepositFee = Fee.parseFee(data, offset);
        Fee stakeWithdrawalFee = Fee.parseFee(data, offset += 16);
        FutureEpochFee nextStakeWithdrawalFee = FutureEpochFee.parseFutureFee(data, offset += 16);
        offset = nextStakeWithdrawalFee == FutureEpochFee.NONE ? ++offset : (offset += 17);
        byte stakeReferralFee = data[offset];
        if (data[++offset] == 0) {
            ++offset;
            solDepositAuthority = null;
        } else {
            solDepositAuthority = PublicKey.readPubKey((byte[])data, (int)(++offset));
            offset += 32;
        }
        Fee solDepositFee = Fee.parseFee(data, offset);
        byte solReferralFee = data[offset += 16];
        if (data[++offset] == 0) {
            ++offset;
            solWithdrawAuthority = null;
        } else {
            solWithdrawAuthority = PublicKey.readPubKey((byte[])data, (int)(++offset));
            offset += 32;
        }
        Fee solWithdrawalFee = Fee.parseFee(data, offset);
        FutureEpochFee nextSolWithdrawalFee = FutureEpochFee.parseFutureFee(data, offset += 16);
        offset = nextSolWithdrawalFee == FutureEpochFee.NONE ? ++offset : (offset += 17);
        long lastEpochPoolTokenSupply = ByteUtil.getInt64LE((byte[])data, (int)offset);
        long lastEpochTotalLamports = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        BigDecimal bigLamports = new BigDecimal(Long.toUnsignedString(totalLamports));
        BigDecimal bigSupply = new BigDecimal(Long.toUnsignedString(poolTokenSupply));
        return new StakePoolState(address, accountType, manager, staker, stakeDepositAuthority, stakeWithdrawBumpSeed, validatorList, reserveStake, poolMint, managerFeeAccount, tokenProgramId, bigLamports, bigSupply, lastUpdateEpoch, lockUp, epochFee, nextEpochFee, preferredDepositValidatorVoteAddress, preferredWithdrawValidatorVoteAddress, stakeDepositFee, stakeWithdrawalFee, nextStakeWithdrawalFee, stakeReferralFee, solDepositAuthority, solDepositFee, solReferralFee, solWithdrawAuthority, solWithdrawalFee, nextSolWithdrawalFee, lastEpochPoolTokenSupply, lastEpochTotalLamports);
    }

    public record Fee(long denominator, long numerator) implements Comparable<Fee>,
    Borsh
    {
        static final int BYTES = 16;

        static Fee parseFee(byte[] data, int offset) {
            return new Fee(ByteUtil.getInt64LE((byte[])data, (int)offset), ByteUtil.getInt64LE((byte[])data, (int)(offset + 8)));
        }

        public BigDecimal toRatio(MathContext mathContext) {
            return this.numerator == 0L || this.denominator == 0L ? BigDecimal.ZERO : BigDecimal.valueOf(this.numerator).divide(BigDecimal.valueOf(this.denominator), mathContext).stripTrailingZeros();
        }

        public BigDecimal toRatio(int scale, RoundingMode roundingMode) {
            return this.numerator == 0L || this.denominator == 0L ? BigDecimal.ZERO : BigDecimal.valueOf(this.numerator).divide(BigDecimal.valueOf(this.denominator), scale, roundingMode).stripTrailingZeros();
        }

        public double toRatio() {
            return this.numerator == 0L || this.denominator == 0L ? 0.0 : (double)this.numerator / (double)this.denominator;
        }

        @Override
        public int compareTo(Fee o) {
            if (this.numerator == 0L || o.numerator == 0L) {
                return Long.compare(this.numerator, o.numerator);
            }
            return Double.compare(this.toRatio(), o.toRatio());
        }

        public int l() {
            return 16;
        }

        public int write(byte[] data, int offset) {
            ByteUtil.putInt64LE((byte[])data, (int)offset, (long)this.denominator);
            ByteUtil.putInt64LE((byte[])data, (int)(offset + 8), (long)this.numerator);
            return 16;
        }
    }

    public record FutureEpochFee(FutureEpoch futureEpoch, Fee fee) {
        private static final FutureEpochFee NONE = new FutureEpochFee(FutureEpoch.NONE, null);
        static final int BYTES = 17;

        static FutureEpochFee parseFutureFee(byte[] data, int offset) {
            byte futureEpochOption = data[offset];
            if (futureEpochOption == 0) {
                return NONE;
            }
            if (futureEpochOption == 1) {
                return new FutureEpochFee(FutureEpoch.ONE, Fee.parseFee(data, offset + 1));
            }
            if (futureEpochOption == 2) {
                return new FutureEpochFee(FutureEpoch.TWO, Fee.parseFee(data, offset + 1));
            }
            throw new IllegalStateException("Unknown FutureEpoch value: " + futureEpochOption);
        }
    }

    public static enum FutureEpoch {
        NONE,
        ONE,
        TWO;

    }
}

