/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.system;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.rpc.Filter;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;
import software.sava.rpc.json.http.response.AccountInfo;
import software.sava.solana.programs.stake.StakeState;
import software.sava.solana.programs.system.SystemProgram;

public record NonceAccount(PublicKey address, int version, State state, PublicKey authority, byte[] nonce, long lamportsPerSignature) {
    public static final int BYTES = 80;
    public static final Filter DATA_SIZE_FILTER = Filter.createDataSizeFilter((int)80);
    public static final int VERSION_OFFSET = 0;
    public static final int STATE_OFFSET = 4;
    public static final int AUTHORITY_OFFSET = 8;
    public static final int NONCE_OFFSET = 40;
    public static final int LAMPORTS_PER_SIG_OFFSET = 72;
    public static final BiFunction<PublicKey, byte[], NonceAccount> FACTORY = NonceAccount::read;

    public static Filter createVersionFilter(int version) {
        byte[] versionBytes = new byte[4];
        ByteUtil.putInt32LE((byte[])versionBytes, (int)0, (int)version);
        return Filter.createMemCompFilter((int)0, (byte[])versionBytes);
    }

    public static Filter createStateFilter(StakeState state) {
        byte[] stateBytes = new byte[4];
        ByteUtil.putInt32LE((byte[])stateBytes, (int)0, (int)state.ordinal());
        return Filter.createMemCompFilter((int)4, (byte[])stateBytes);
    }

    public static Filter createAuthorityFilter(PublicKey authority) {
        return Filter.createMemCompFilter((int)8, (PublicKey)authority);
    }

    public static Filter createNonceFilter(byte[] nonce) {
        return Filter.createMemCompFilter((int)40, (byte[])nonce);
    }

    public static Filter createVersionFilter(long lamportsPerSignature) {
        byte[] bytes = new byte[8];
        ByteUtil.putInt64LE((byte[])bytes, (int)0, (long)lamportsPerSignature);
        return Filter.createMemCompFilter((int)0, (byte[])bytes);
    }

    public static NonceAccount read(byte[] data, int offset) {
        return NonceAccount.read(null, data, offset);
    }

    public static NonceAccount read(AccountInfo<byte[]> accountInfo) {
        return NonceAccount.read(accountInfo.pubKey(), (byte[])accountInfo.data(), 0);
    }

    public static NonceAccount read(PublicKey address, byte[] data) {
        return NonceAccount.read(address, data, 0);
    }

    public static NonceAccount read(PublicKey address, byte[] data, int offset) {
        int version = ByteUtil.getInt32LE((byte[])data, (int)offset);
        State state = State.values()[ByteUtil.getInt32LE((byte[])data, (int)(offset += 4))];
        PublicKey authority = PublicKey.readPubKey((byte[])data, (int)(offset += 4));
        byte[] nonce = new byte[32];
        System.arraycopy(data, offset += 32, nonce, 0, 32);
        long lamportsPerSignature = ByteUtil.getInt64LE((byte[])data, (int)(offset += 32));
        return new NonceAccount(address, version, state, authority, nonce, lamportsPerSignature);
    }

    public Instruction advanceNonceAccount() {
        return this.advanceNonceAccount(SolanaAccounts.MAIN_NET);
    }

    public Instruction advanceNonceAccount(SolanaAccounts solanaAccounts) {
        return SystemProgram.advanceNonceAccount(solanaAccounts, this.address, this.authority);
    }

    public void setNonce(Transaction transaction) {
        this.setNonce(SolanaAccounts.MAIN_NET, transaction);
    }

    public void setNonce(SolanaAccounts solanaAccounts, Transaction transaction) {
        transaction.setRecentBlockHash(this.nonce);
        Instruction advanceNonceIx = this.advanceNonceAccount(solanaAccounts);
        transaction.prependIx(advanceNonceIx);
    }

    public static enum State {
        Uninitialized,
        Initialized;

    }
}

