/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.system;

import java.util.List;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.serde.SerdeUtil;

public final class SystemProgram {
    public static Instruction allocate(AccountMeta invokedProgram, PublicKey newAccount, long space) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)newAccount));
        byte[] data = new byte[12];
        Instructions.Allocate.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)space);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction allocateWithSeed(AccountMeta invokedProgram, AccountWithSeed accountWithSeed, long space, PublicKey programOwner) {
        PublicKey baseAccount = accountWithSeed.baseKey();
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)accountWithSeed.publicKey()), AccountMeta.createReadOnlySigner((PublicKey)baseAccount));
        byte[] seedBytes = accountWithSeed.asciiSeed();
        byte[] data = new byte[36 + (8 + seedBytes.length) + 8 + 32];
        int i = Instructions.AllocateWithSeed.write(data);
        i += baseAccount.write(data, i);
        i += SerdeUtil.writeString(seedBytes, data, i);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)space);
        programOwner.write(data, i += 8);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction assign(AccountMeta invokedProgram, PublicKey newAccount, PublicKey programOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)newAccount));
        byte[] data = new byte[36];
        Instructions.Assign.write(data);
        programOwner.write(data, 4);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction assignWithSeed(AccountMeta invokedProgram, AccountWithSeed accountWithSeed, PublicKey baseAccount, PublicKey programOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)accountWithSeed.publicKey()), AccountMeta.createReadOnlySigner((PublicKey)baseAccount));
        byte[] seedBytes = accountWithSeed.asciiSeed();
        byte[] data = new byte[36 + (8 + seedBytes.length) + 32];
        int i = Instructions.AssignWithSeed.write(data);
        i += baseAccount.write(data, i);
        i += SerdeUtil.writeString(seedBytes, data, i);
        programOwner.write(data, i);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction createAccount(AccountMeta invokedProgram, PublicKey fromPublicKey, PublicKey newAccountPublicKey, long lamports, long space, PublicKey programOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)fromPublicKey), AccountMeta.createWritableSigner((PublicKey)newAccountPublicKey));
        byte[] data = new byte[52];
        int i = Instructions.CreateAccount.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)space);
        programOwner.write(data, i += 8);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction createAccountWithSeed(AccountMeta invokedProgram, PublicKey fromPublicKey, AccountWithSeed accountWithSeed, long lamports, long space, PublicKey programOwner) {
        AccountMeta fromSigner = AccountMeta.createWritableSigner((PublicKey)fromPublicKey);
        AccountMeta accountMeta = AccountMeta.createWrite((PublicKey)accountWithSeed.publicKey());
        PublicKey baseAccount = accountWithSeed.baseKey();
        byte[] seedBytes = accountWithSeed.asciiSeed();
        List<AccountMeta> keys = baseAccount.equals((Object)fromPublicKey) ? List.of(fromSigner, accountMeta) : List.of(fromSigner, accountMeta, AccountMeta.createReadOnlySigner((PublicKey)baseAccount));
        byte[] data = new byte[36 + (8 + seedBytes.length) + 8 + 8 + 32];
        int i = Instructions.CreateAccountWithSeed.write(data);
        baseAccount.write(data, i);
        i += 32;
        i += SerdeUtil.writeString(seedBytes, data, i);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)space);
        programOwner.write(data, i += 8);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction transfer(AccountMeta invokedProgram, PublicKey fromPublicKey, PublicKey toPublicKey, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)fromPublicKey), AccountMeta.createWrite((PublicKey)toPublicKey));
        byte[] data = new byte[12];
        Instructions.Transfer.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction transferWithSeed(AccountMeta invokedProgram, AccountWithSeed accountWithSeed, PublicKey recipientAccount, long lamports, PublicKey programOwner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)accountWithSeed.publicKey()), AccountMeta.createReadOnlySigner((PublicKey)accountWithSeed.baseKey()), AccountMeta.createWrite((PublicKey)recipientAccount));
        byte[] seedBytes = accountWithSeed.asciiSeed();
        byte[] data = new byte[12 + (8 + seedBytes.length) + 32];
        int i = Instructions.TransferWithSeed.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)lamports);
        i += 8;
        i += SerdeUtil.writeString(seedBytes, data, i);
        programOwner.write(data, i);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction advanceNonceAccount(SolanaAccounts solanaAccounts, PublicKey nonceAccount, PublicKey nonceAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nonceAccount), solanaAccounts.readRecentBlockhashesSysVar(), AccountMeta.createReadOnlySigner((PublicKey)nonceAuthority));
        byte[] data = new byte[4];
        Instructions.AdvanceNonceAccount.write(data);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedSystemProgram(), keys, (byte[])data);
    }

    public static Instruction withdrawNonceAccount(SolanaAccounts solanaAccounts, PublicKey nonceAccount, PublicKey recipient, PublicKey nonceAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nonceAccount), AccountMeta.createWrite((PublicKey)recipient), solanaAccounts.readRecentBlockhashesSysVar(), solanaAccounts.readRentSysVar(), AccountMeta.createReadOnlySigner((PublicKey)nonceAuthority));
        byte[] data = new byte[12];
        Instructions.WithdrawNonceAccount.write(data);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedSystemProgram(), keys, (byte[])data);
    }

    public static Instruction initializeNonceAccount(SolanaAccounts solanaAccounts, PublicKey nonceAccount, PublicKey nonceAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nonceAccount), solanaAccounts.readRecentBlockhashesSysVar(), solanaAccounts.readRentSysVar());
        byte[] data = new byte[36];
        Instructions.InitializeNonceAccount.write(data);
        nonceAuthority.write(data, 4);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedSystemProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeNonceAccount(AccountMeta invokedProgram, PublicKey nonceAccount, PublicKey currentNonceAuthority, PublicKey newNonceAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nonceAccount), AccountMeta.createReadOnlySigner((PublicKey)currentNonceAuthority));
        byte[] data = new byte[36];
        Instructions.AuthorizeNonceAccount.write(data);
        newNonceAuthority.write(data, 4);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction authorizeNonceAccount(SolanaAccounts solanaAccounts, PublicKey nonceAccount, PublicKey currentNonceAuthority, PublicKey newNonceAuthority) {
        return SystemProgram.authorizeNonceAccount(solanaAccounts.invokedSystemProgram(), nonceAccount, currentNonceAuthority, newNonceAuthority);
    }

    public static Instruction upgradeNonceAccount(AccountMeta invokedProgram, PublicKey nonceAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nonceAccount));
        byte[] data = new byte[4];
        Instructions.UpgradeNonceAccount.write(data);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction upgradeNonceAccount(SolanaAccounts solanaAccounts, PublicKey nonceAccount) {
        return SystemProgram.upgradeNonceAccount(solanaAccounts.invokedSystemProgram(), nonceAccount);
    }

    private SystemProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        CreateAccount{}
        ,
        Assign{}
        ,
        Transfer{}
        ,
        CreateAccountWithSeed{}
        ,
        AdvanceNonceAccount,
        WithdrawNonceAccount,
        InitializeNonceAccount,
        AuthorizeNonceAccount,
        Allocate{}
        ,
        AllocateWithSeed{}
        ,
        AssignWithSeed{}
        ,
        TransferWithSeed{}
        ,
        UpgradeNonceAccount;

        private final byte[] data = Discriminator.serializeDiscriminator((Enum)this);

        public byte[] data() {
            return this.data;
        }
    }

    public record AuthorizeNonceAccount(byte[] discriminator, PublicKey newNonceAuthority) {
        public static AuthorizeNonceAccount read(Instruction instruction) {
            return AuthorizeNonceAccount.read(instruction.data(), instruction.offset());
        }

        public static AuthorizeNonceAccount read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            return new AuthorizeNonceAccount(discriminator, PublicKey.readPubKey((byte[])data, (int)(offset + discriminator.length)));
        }
    }

    public record InitializeNonceAccount(byte[] discriminator, PublicKey nonceAuthority) {
        public static InitializeNonceAccount read(Instruction instruction) {
            return InitializeNonceAccount.read(instruction.data(), instruction.offset());
        }

        public static InitializeNonceAccount read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            return new InitializeNonceAccount(discriminator, PublicKey.readPubKey((byte[])data, (int)(offset + discriminator.length)));
        }
    }

    public record WithdrawNonceAccount(byte[] discriminator, long lamports) {
        public static WithdrawNonceAccount read(Instruction instruction) {
            return WithdrawNonceAccount.read(instruction.data(), instruction.offset());
        }

        public static WithdrawNonceAccount read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            return new WithdrawNonceAccount(discriminator, ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length)));
        }
    }

    public record TransferWithSeed(byte[] discriminator, long lamports, byte[] seed, PublicKey programOwner) {
        public static TransferWithSeed read(Instruction instruction) {
            return TransferWithSeed.read(instruction.data(), instruction.offset());
        }

        public static TransferWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)i);
            byte[] seed = SerdeUtil.readString(data, i += 8);
            PublicKey programOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8 + seed.length));
            return new TransferWithSeed(discriminator, lamports, seed, programOwner);
        }
    }

    public record Transfer(byte[] discriminator, long lamports) {
        public static Transfer read(Instruction instruction) {
            return Transfer.read(instruction.data(), instruction.offset());
        }

        public static Transfer read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            return new Transfer(discriminator, ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length)));
        }
    }

    public record CreateAccountWithSeed(byte[] discriminator, PublicKey baseAccount, byte[] seed, long lamports, long space, PublicKey programOwner) {
        public static CreateAccountWithSeed read(Instruction instruction) {
            return CreateAccountWithSeed.read(instruction.data(), instruction.offset());
        }

        public static CreateAccountWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey baseAccount = PublicKey.readPubKey((byte[])data, (int)i);
            byte[] seed = SerdeUtil.readString(data, i += 32);
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)(i += 8 + seed.length));
            long space = ByteUtil.getInt64LE((byte[])data, (int)(i += 8));
            PublicKey programOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8));
            return new CreateAccountWithSeed(discriminator, baseAccount, seed, lamports, space, programOwner);
        }
    }

    public record CreateAccount(byte[] discriminator, long lamports, long space, PublicKey programOwner) {
        public static CreateAccount read(Instruction instruction) {
            return CreateAccount.read(instruction.data(), instruction.offset());
        }

        public static CreateAccount read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            long lamports = ByteUtil.getInt64LE((byte[])data, (int)i);
            long space = ByteUtil.getInt64LE((byte[])data, (int)(i += 8));
            PublicKey programOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8));
            return new CreateAccount(discriminator, lamports, space, programOwner);
        }
    }

    public record AssignWithSeed(byte[] discriminator, PublicKey baseAccount, byte[] seed, PublicKey programOwner) {
        public static AssignWithSeed read(Instruction instruction) {
            return AssignWithSeed.read(instruction.data(), instruction.offset());
        }

        public static AssignWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey baseAccount = PublicKey.readPubKey((byte[])data, (int)i);
            byte[] seed = SerdeUtil.readString(data, i += 32);
            PublicKey programOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8 + seed.length));
            return new AssignWithSeed(discriminator, baseAccount, seed, programOwner);
        }
    }

    public record Assign(byte[] discriminator, PublicKey programOwner) {
        public static Assign read(Instruction instruction) {
            return Assign.read(instruction.data(), instruction.offset());
        }

        public static Assign read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            return new Assign(discriminator, PublicKey.readPubKey((byte[])data, (int)(offset + discriminator.length)));
        }
    }

    public record AllocateWithSeed(byte[] discriminator, PublicKey baseAccount, byte[] seed, long space, PublicKey programOwner) {
        public static AllocateWithSeed read(Instruction instruction) {
            return AllocateWithSeed.read(instruction.data(), instruction.offset());
        }

        public static AllocateWithSeed read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            int i = offset + discriminator.length;
            PublicKey baseAccount = PublicKey.readPubKey((byte[])data, (int)i);
            byte[] seed = SerdeUtil.readString(data, i += 32);
            long space = ByteUtil.getInt64LE((byte[])data, (int)(i += 8 + seed.length));
            PublicKey programOwner = PublicKey.readPubKey((byte[])data, (int)(i += 8));
            return new AllocateWithSeed(discriminator, baseAccount, seed, space, programOwner);
        }
    }

    public record Allocate(byte[] discriminator, long space) {
        public static Allocate read(Instruction instruction) {
            return Allocate.read(instruction.data(), instruction.offset());
        }

        public static Allocate read(byte[] data, int offset) {
            if (data == null || data.length == 0) {
                return null;
            }
            byte[] discriminator = SerdeUtil.readDiscriminator(data, offset);
            long space = ByteUtil.getInt64LE((byte[])data, (int)(offset + discriminator.length));
            return new Allocate(discriminator, space);
        }
    }
}

