/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.token;

import java.util.List;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;

public final class AssociatedTokenProgram {
    public static ProgramDerivedAddress findATA(SolanaAccounts solanaAccounts, PublicKey owner, PublicKey tokenProgram, PublicKey mint) {
        return PublicKey.findProgramAddress(List.of(owner.toByteArray(), tokenProgram.toByteArray(), mint.toByteArray()), (PublicKey)solanaAccounts.associatedTokenAccountProgram());
    }

    public static ProgramDerivedAddress findATA(SolanaAccounts solanaAccounts, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.findATA(solanaAccounts, owner, solanaAccounts.tokenProgram(), mint);
    }

    public static ProgramDerivedAddress findATA2022(SolanaAccounts solanaAccounts, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.findATA(solanaAccounts, owner, solanaAccounts.token2022Program(), mint);
    }

    public static Instruction createATAForProgram(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        List<AccountMeta> keys = List.of(AccountMeta.createWritableSigner((PublicKey)fundingAccount), AccountMeta.createWrite((PublicKey)pda), AccountMeta.createRead((PublicKey)owner), AccountMeta.createRead((PublicKey)mint), solanaAccounts.readSystemProgram(), tokenProgram);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAssociatedTokenAccountProgram(), keys, (byte[])(idempotent ? Instructions.CreateIdempotent.discriminatorBytes : Instructions.Create.discriminatorBytes));
    }

    public static Instruction createATAForProgram(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint, PublicKey tokenProgram) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, pda, owner, mint, AccountMeta.createRead((PublicKey)tokenProgram));
    }

    public static Instruction createATAForProgram(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey owner, PublicKey mint, AccountMeta tokenProgram) {
        ProgramDerivedAddress pda = AssociatedTokenProgram.findATA(solanaAccounts, owner, tokenProgram.publicKey(), mint);
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, pda.publicKey(), owner, mint, tokenProgram);
    }

    public static Instruction createATAForProgram(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey owner, PublicKey mint, PublicKey tokenProgram) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, owner, mint, AccountMeta.createRead((PublicKey)tokenProgram));
    }

    public static Instruction createATA(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, pda, owner, mint, solanaAccounts.readTokenProgram());
    }

    public static Instruction createATA(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, owner, mint, solanaAccounts.readTokenProgram());
    }

    public static Instruction createATA(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey mint) {
        return AssociatedTokenProgram.createATA(idempotent, solanaAccounts, fundingAccount, fundingAccount, mint);
    }

    public static Instruction createATA2022(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey pda, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, pda, owner, mint, solanaAccounts.readToken2022Program());
    }

    public static Instruction createATA2022(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey owner, PublicKey mint) {
        return AssociatedTokenProgram.createATAForProgram(idempotent, solanaAccounts, fundingAccount, owner, mint, solanaAccounts.readToken2022Program());
    }

    public static Instruction createATA2022(boolean idempotent, SolanaAccounts solanaAccounts, PublicKey fundingAccount, PublicKey mint) {
        return AssociatedTokenProgram.createATA2022(idempotent, solanaAccounts, fundingAccount, fundingAccount, mint);
    }

    public static Instruction recoverNested(SolanaAccounts solanaAccounts, PublicKey nestedTokenAccount, PublicKey nestedTokenMint, PublicKey walletTokenAccount, PublicKey ownerTokenAccount, PublicKey ownerTokenMint, PublicKey owner, AccountMeta tokenProgram) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)nestedTokenAccount), AccountMeta.createRead((PublicKey)nestedTokenMint), AccountMeta.createWrite((PublicKey)walletTokenAccount), AccountMeta.createRead((PublicKey)ownerTokenAccount), AccountMeta.createRead((PublicKey)ownerTokenMint), AccountMeta.createWritableSigner((PublicKey)owner), solanaAccounts.readSystemProgram(), tokenProgram);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedAssociatedTokenAccountProgram(), keys, (byte[])Instructions.RecoverNested.discriminatorBytes);
    }

    private AssociatedTokenProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        Create,
        CreateIdempotent,
        RecoverNested;

        private final byte[] discriminatorBytes = new byte[]{(byte)this.ordinal()};

        public byte[] data() {
            return this.discriminatorBytes;
        }

        public int write(byte[] bytes, int i) {
            bytes[i] = (byte)this.ordinal();
            return 1;
        }

        public int length() {
            return 1;
        }
    }
}

