/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.charts;

import software.xdev.chartjs.model.charts.AbstractChart;
import software.xdev.chartjs.model.data.ScatterData;
import software.xdev.chartjs.model.dataset.ScatterDataset;
import software.xdev.chartjs.model.options.LineOptions;

public class ScatterChart
extends AbstractChart<ScatterChart, LineOptions, ScatterData> {
    public ScatterChart() {
    }

    public ScatterChart(ScatterData data) {
        super(data);
    }

    public ScatterChart(ScatterData data, LineOptions options) {
        super(data, options);
    }

    public static ScatterData data() {
        return new ScatterData();
    }

    public static LineOptions options() {
        return new LineOptions();
    }

    @Override
    public String getType() {
        return "scatter";
    }

    @Override
    public boolean isDrawable() {
        boolean sufficientData = false;
        for (ScatterDataset dataset : ((ScatterData)this.getData()).getDatasets()) {
            if (dataset.getXAxisID() != null && !this.hasScaleWithId(dataset.getXAxisID())) {
                return false;
            }
            if (dataset.getYAxisID() != null && !this.hasScaleWithId(dataset.getYAxisID())) {
                return false;
            }
            if (dataset.getData().isEmpty()) continue;
            sufficientData = true;
        }
        return sufficientData;
    }

    private boolean hasScaleWithId(String id) {
        if (this.getOptions() != null && ((LineOptions)this.getOptions()).getScales() != null && ((LineOptions)this.getOptions()).getScales().getScalesList() != null) {
            return ((LineOptions)this.getOptions()).getScales().getScalesList().get(id) != null;
        }
        return false;
    }
}

