/*
 * Copyright © 2023 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.xdev.chartjs.model.charts;

import software.xdev.chartjs.model.data.HomogeneousData;
import software.xdev.chartjs.model.options.Options;


public abstract class HomogeneousChart<T, O extends Options<O, ?>, D extends HomogeneousData<D, ?>>
	extends AbstractChart<T, O, D>
{
	protected HomogeneousChart()
	{
	}
	
	protected HomogeneousChart(final D data)
	{
		super(data);
	}
	
	protected HomogeneousChart(final D data, final O options)
	{
		super(data, options);
	}
	
	protected boolean hasScaleWithId(final String id)
	{
		if(this.getOptions() != null
			&& this.getOptions().getScales() != null
			&& this.getOptions().getScales().getScales() != null)
		{
			return this.getOptions().getScales().getScales().get(id) != null;
		}
		return false;
	}
}
