/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.jndi.JndiObjectLocator;

public abstract class AbstractSlsbInvokerInterceptor
extends JndiObjectLocator
implements MethodInterceptor {
    private boolean lookupHomeOnStartup = true;
    private boolean cacheHome = true;
    private Object cachedHome;
    private Method createMethod;

    public void setLookupHomeOnStartup(boolean lookupHomeOnStartup) {
        this.lookupHomeOnStartup = lookupHomeOnStartup;
    }

    public void setCacheHome(boolean cacheHome) {
        this.cacheHome = cacheHome;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupHomeOnStartup) {
            this.refreshHome();
        }
    }

    protected void refreshHome() throws NamingException {
        Object home = this.lookup();
        this.createMethod = this.getCreateMethod(home);
        if (this.cacheHome) {
            this.cachedHome = home;
        }
    }

    protected Method getCreateMethod(Object home) throws AspectException {
        try {
            return home.getClass().getMethod("create", null);
        }
        catch (NoSuchMethodException ex) {
            throw new AspectException("EJB home [" + this.cachedHome + "] has no no-arg create() method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getHome() throws NamingException {
        if (!this.cacheHome || this.lookupHomeOnStartup && !this.isHomeRefreshable()) {
            return this.cachedHome != null ? this.cachedHome : this.lookup();
        }
        AbstractSlsbInvokerInterceptor abstractSlsbInvokerInterceptor = this;
        synchronized (abstractSlsbInvokerInterceptor) {
            if (this.cachedHome == null) {
                this.cachedHome = this.lookup();
                this.createMethod = this.getCreateMethod(this.cachedHome);
            }
            return this.cachedHome;
        }
    }

    protected boolean isHomeRefreshable() {
        return false;
    }

    protected Object create() throws NamingException, InvocationTargetException {
        try {
            Object home = this.getHome();
            Method createMethod = this.createMethod;
            if (createMethod == null) {
                createMethod = this.getCreateMethod(home);
            }
            return this.createMethod.invoke(home, null);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Could not access EJB home create() method", (Throwable)ex);
        }
    }
}

