/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;

public abstract class AdvisorChainFactoryUtils {
    public static AdvisorChainFactory SIMPLE_ADVISOR_CHAIN_FACTORY = new AdvisorChainFactory(){

        public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
            return AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
        }

        public void activated(AdvisedSupport advisedSupport) {
        }

        public void adviceChanged(AdvisedSupport advisedSupport) {
        }
    };

    public static List calculateInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        ArrayList<InterceptorAndDynamicMethodMatcher> interceptors = new ArrayList<InterceptorAndDynamicMethodMatcher>(config.getAdvisors().length);
        for (int i = 0; i < config.getAdvisors().length; ++i) {
            IntroductionAdvisor ia;
            MethodInterceptor interceptor;
            Advisor advisor = config.getAdvisors()[i];
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!pointcutAdvisor.getPointcut().getClassFilter().matches(targetClass)) continue;
                interceptor = (MethodInterceptor)GlobalAdvisorAdapterRegistry.getInstance().getInterceptor(advisor);
                MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (!mm.matches(method, targetClass)) continue;
                if (mm.isRuntime()) {
                    interceptors.add(new InterceptorAndDynamicMethodMatcher(interceptor, mm));
                    continue;
                }
                interceptors.add((InterceptorAndDynamicMethodMatcher)interceptor);
                continue;
            }
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) continue;
            interceptor = (MethodInterceptor)GlobalAdvisorAdapterRegistry.getInstance().getInterceptor(advisor);
            interceptors.add((InterceptorAndDynamicMethodMatcher)interceptor);
        }
        return interceptors;
    }
}

