/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.aopalliance.aop.AspectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

class Cglib2AopProxy
implements AopProxy,
MethodInterceptor,
CallbackFilter {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AdvisedSupport advised;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;
    static /* synthetic */ Class class$java$lang$Object;

    protected Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        if (config == null) {
            throw new AopConfigException("Cannot create AopProxy with null ProxyConfig");
        }
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("Cannot create AopProxy with no advisors and no target source");
        }
        this.advised = config;
        if (this.advised.getTargetSource().getTargetClass() == null) {
            throw new AopConfigException("Either an interface or a target is required for proxy creation");
        }
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object object;
        boolean setProxyContext;
        Object oldProxy;
        block20: {
            Object target;
            Class<?> targetClass;
            TargetSource targetSource;
            MethodInvocationImpl invocation;
            block18: {
                Object object2;
                block19: {
                    block16: {
                        Boolean bl;
                        block17: {
                            invocation = null;
                            oldProxy = null;
                            setProxyContext = false;
                            targetSource = this.advised.targetSource;
                            targetClass = null;
                            target = null;
                            if (!this.isEqualsMethod(method)) break block16;
                            bl = new Boolean(this.equals(args[0]));
                            Object var15_15 = null;
                            if (target == null || targetSource.isStatic()) break block17;
                            targetSource.releaseTarget(target);
                        }
                        if (setProxyContext) {
                            AopContext.setCurrentProxy(oldProxy);
                        }
                        return bl;
                    }
                    if ((class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = Cglib2AopProxy.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised) != method.getDeclaringClass()) break block18;
                    object2 = AopProxyUtils.invokeJoinpointUsingReflection(this.advised, method, args);
                    Object var15_16 = null;
                    if (target == null || targetSource.isStatic()) break block19;
                    targetSource.releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
                return object2;
            }
            try {
                List chain;
                Object retVal = null;
                target = targetSource.getTarget();
                if (target != null) {
                    targetClass = target.getClass();
                }
                if (this.advised.exposeProxy) {
                    oldProxy = AopContext.setCurrentProxy(proxy);
                    setProxyContext = true;
                }
                if ((chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, proxy, method, targetClass)).isEmpty()) {
                    retVal = methodProxy.invoke(target, args);
                } else {
                    invocation = new MethodInvocationImpl(proxy, target, method, args, targetClass, chain, methodProxy);
                    retVal = invocation.proceed();
                }
                object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                Object var15_17 = null;
                if (target == null || targetSource.isStatic()) break block20;
            }
            catch (Throwable t) {
                try {
                    if (t instanceof Exception && !(t instanceof RuntimeException)) {
                        Class<?>[] permittedThrows = method.getExceptionTypes();
                        for (int i = 0; i < permittedThrows.length; ++i) {
                            if (!permittedThrows[i].isAssignableFrom(t.getClass())) continue;
                            throw t;
                        }
                        throw new UndeclaredThrowableException(t);
                    }
                    throw t;
                }
                catch (Throwable throwable) {
                    block21: {
                        Object var15_18 = null;
                        if (target != null && !targetSource.isStatic()) {
                            targetSource.releaseTarget(target);
                        }
                        if (!setProxyContext) break block21;
                        AopContext.setCurrentProxy(oldProxy);
                    }
                    throw throwable;
                }
            }
            targetSource.releaseTarget(target);
        }
        if (setProxyContext) {
            AopContext.setCurrentProxy(oldProxy);
        }
        return object;
    }

    protected static Object massageReturnTypeIfNecessary(Object proxy, Object target, Object retVal) {
        if (retVal != null && retVal == target) {
            retVal = proxy;
        }
        return retVal;
    }

    protected final boolean isEqualsMethod(Method m) {
        return "equals".equals(m.getName()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public Object getProxy() {
        return this.getProxy(Thread.currentThread().getContextClassLoader());
    }

    public Object getProxy(ClassLoader cl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating CGLIB proxy for [" + this.advised.getTargetSource().getTargetClass() + "]"));
        }
        Enhancer e = new Enhancer();
        try {
            e.setSuperclass(this.advised.getTargetSource().getTargetClass());
            e.setCallbackFilter((CallbackFilter)this);
            e.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            Object targetInvoker = this.canApplyCglibOptimizations() ? new StaticTargetInvoker(this.advised.getTargetSource().getTarget()) : new DynamicTargetInvoker();
            e.setCallbacks(new Callback[]{this, targetInvoker, NoOp.INSTANCE});
            return e.create();
        }
        catch (CodeGenerationException ex) {
            throw new AspectException("Couldn't generate CGLIB subclass of class '" + this.advised.getTargetSource().getTargetClass() + "': " + "Common causes of this problem include using a final class, or a non-visible class", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AopConfigException("Unexpected AOP exception", ex);
        }
    }

    private boolean canApplyCglibOptimizations() {
        return this.advised.getOptimize() && this.advised.getTargetSource().isStatic() && !this.advised.getExposeProxy();
    }

    public int accept(Method method) {
        boolean haveAdvice;
        if (method.getName().equals("finalize") && method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 2;
        }
        if (!this.canApplyCglibOptimizations()) {
            return 0;
        }
        Class targetClass = this.advised.getTargetSource().getTargetClass();
        if (this.isEqualsMethod(method)) {
            return 0;
        }
        List chain = this.advised.getAdvisorChainFactory().getInterceptorsAndDynamicInterceptionAdvice(this.advised, null, method, targetClass);
        boolean bl = haveAdvice = !chain.isEmpty();
        if (haveAdvice) {
            this.logger.info((Object)("CGLIB proxy for " + targetClass.getName() + " WILL override " + method));
        } else {
            this.logger.info((Object)("Chain is empty for " + method + "; will NOT override"));
        }
        return haveAdvice ? 0 : 1;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Cglib2AopProxy otherCglibProxy = null;
        if (other instanceof Cglib2AopProxy) {
            otherCglibProxy = (Cglib2AopProxy)other;
        } else if (other instanceof Factory) {
            Callback callback = ((Factory)other).getCallback(0);
            if (!(callback instanceof Cglib2AopProxy)) {
                return false;
            }
            otherCglibProxy = (Cglib2AopProxy)callback;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, otherCglibProxy.advised);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodInvocationImpl
    extends ReflectiveMethodInvocation {
        private MethodProxy methodProxy;

        public MethodInvocationImpl(Object proxy, Object target, Method m, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target, m, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
        }

        protected Object invokeJoinpoint() throws Throwable {
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private static class StaticTargetInvoker
    implements MethodInterceptor {
        private final Object target;

        public StaticTargetInvoker(Object target) {
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object ret = methodProxy.invoke(this.target, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, ret);
        }
    }

    private class DynamicTargetInvoker
    implements MethodInterceptor {
        private DynamicTargetInvoker() {
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = Cglib2AopProxy.this.advised.getTargetSource().getTarget();
            Object ret = methodProxy.invoke(target, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, ret);
        }
    }
}

