/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class ResourceEntityResolver
extends BeansDtdResolver {
    private final ApplicationContext applicationContext;

    public ResourceEntityResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        InputSource source = super.resolveEntity(publicId, systemId);
        if (source == null && systemId != null) {
            String resourcePath = null;
            try {
                String givenUrl = new URL(systemId).toString();
                String systemRootUrl = new File("").toURL().toString();
                if (givenUrl.startsWith(systemRootUrl)) {
                    resourcePath = givenUrl.substring(systemRootUrl.length());
                }
            }
            catch (MalformedURLException ex) {
                resourcePath = systemId;
            }
            if (resourcePath != null) {
                this.logger.debug((Object)("Trying to locate entity [" + systemId + "] as application context resource [" + resourcePath + "]"));
                Resource resource = this.applicationContext.getResource(resourcePath);
                this.logger.info((Object)("Found entity [" + systemId + "] as application context resource [" + resourcePath + "]"));
                source = new InputSource(resource.getInputStream());
                source.setPublicId(publicId);
                source.setSystemId(systemId);
            }
        }
        return source;
    }
}

