/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedStatement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class JBossNativeJdbcExtractor
implements NativeJdbcExtractor {
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return false;
    }

    public Connection getNativeConnection(Connection con) throws SQLException {
        if (con instanceof WrappedConnection) {
            return ((WrappedConnection)con).getUnderlyingConnection();
        }
        return con;
    }

    public Connection getNativeConnectionFromStatement(Statement stmt) throws SQLException {
        return this.getNativeConnection(stmt.getConnection());
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (stmt instanceof WrappedStatement) {
            return ((WrappedStatement)stmt).getUnderlyingStatement();
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        if (ps instanceof WrappedPreparedStatement) {
            return (PreparedStatement)((WrappedPreparedStatement)ps).getUnderlyingStatement();
        }
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        if (cs instanceof WrappedCallableStatement) {
            return (CallableStatement)((WrappedCallableStatement)cs).getUnderlyingStatement();
        }
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        return rs;
    }
}

