/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class SimpleNativeJdbcExtractor
implements NativeJdbcExtractor {
    private boolean nativeConnectionNecessaryForNativePreparedStatements = false;
    private boolean nativeConnectionNecessaryForNativeCallableStatements = false;

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return false;
    }

    public void setNativeConnectionNecessaryForNativePreparedStatements(boolean nativeConnectionNecessary) {
        this.nativeConnectionNecessaryForNativePreparedStatements = nativeConnectionNecessary;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return this.nativeConnectionNecessaryForNativePreparedStatements;
    }

    public void setNativeConnectionNecessaryForNativeCallableStatements(boolean nativeConnectionNecessary) {
        this.nativeConnectionNecessaryForNativeCallableStatements = nativeConnectionNecessary;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return this.nativeConnectionNecessaryForNativeCallableStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getNativeConnection(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            Connection connection = stmt.getConnection();
            return connection;
        }
        finally {
            JdbcUtils.closeStatement(stmt);
        }
    }

    public Connection getNativeConnectionFromStatement(Statement stmt) throws SQLException {
        if (this.nativeConnectionNecessaryForNativePreparedStatements && stmt instanceof PreparedStatement) {
            return this.getNativeConnection(stmt.getConnection());
        }
        if (this.nativeConnectionNecessaryForNativeCallableStatements && stmt instanceof CallableStatement) {
            return this.getNativeConnection(stmt.getConnection());
        }
        return stmt.getConnection();
    }

    public Statement getNativeStatement(Statement stmt) {
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) {
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) {
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        return rs;
    }
}

