/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.enhydra.jdbc.core.CoreConnection;
import org.enhydra.jdbc.core.CorePreparedStatement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class XAPoolNativeJdbcExtractor
implements NativeJdbcExtractor {
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    public Connection getNativeConnection(Connection con) throws SQLException {
        if (con instanceof CoreConnection) {
            return ((CoreConnection)con).con;
        }
        return con;
    }

    public Connection getNativeConnectionFromStatement(Statement stmt) throws SQLException {
        return this.getNativeConnection(stmt.getConnection());
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        if (ps instanceof CorePreparedStatement) {
            return ((CorePreparedStatement)ps).ps;
        }
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        return rs;
    }
}

