/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.util.Assert;

public abstract class BeanUtils {
    private static final Map primitiveWrapperTypeMap = new HashMap(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;

    public static Object instantiateClass(Class clazz) throws BeansException {
        Assert.notNull(clazz, "clazz must not be null");
        if (clazz.isInterface()) {
            throw new FatalBeanException("Class [" + clazz.getName() + "] cannot be instantiated: it is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz.getDeclaredConstructor(null), null);
        }
        catch (NoSuchMethodException ex) {
            throw new FatalBeanException("Could not instantiate class [" + clazz.getName() + "]: no default constructor found", ex);
        }
    }

    public static Object instantiateClass(Constructor ctor, Object[] args) throws BeansException {
        Assert.notNull(ctor, "ctor must not be null");
        try {
            if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
                ctor.setAccessible(true);
            }
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new FatalBeanException("Could not instantiate class [" + ctor.getDeclaringClass().getName() + "]: Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Could not instantiate class [" + ctor.getDeclaringClass().getName() + "]: Has the class definition changed? Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new FatalBeanException("Could not instantiate class [" + ctor.getDeclaringClass().getName() + "]: illegal args for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new FatalBeanException("Could not instantiate class [" + ctor.getDeclaringClass().getName() + "]; constructor threw exception", ex.getTargetException());
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            if (clazz.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class clazz, String methodName) {
        Method[] methods = clazz.getMethods();
        Method targetMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || targetMethod != null && methods[i].getParameterTypes().length >= targetMethod.getParameterTypes().length) continue;
            targetMethod = methods[i];
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, methodName);
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class clazz, String methodName) {
        Method[] methods = clazz.getDeclaredMethods();
        Method targetMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || targetMethod != null && methods[i].getParameterTypes().length >= targetMethod.getParameterTypes().length) continue;
            targetMethod = methods[i];
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        if (clazz.getSuperclass() != null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return null;
    }

    public static boolean isAssignable(Class type, Object value) {
        Assert.notNull(type, "type must not be null");
        return value != null ? BeanUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        Assert.notNull(targetType, "targetType must not be null");
        Assert.notNull(valueType, "valueType must not be null");
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }

    public static boolean isSimpleProperty(Class clazz) {
        Assert.notNull(clazz, "clazz must not be null");
        return clazz.isPrimitive() || BeanUtils.isPrimitiveArray(clazz) || BeanUtils.isPrimitiveWrapper(clazz) || BeanUtils.isPrimitiveWrapperArray(clazz) || clazz.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtils.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz.equals(class$java$lang$Class == null ? (class$java$lang$Class = BeanUtils.class$("java.lang.Class")) : class$java$lang$Class) || clazz.equals(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BeanUtils.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        return clazz.isArray() && BeanUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static void copyProperties(Object source, Object target) throws IllegalArgumentException, BeansException {
        BeanUtils.copyProperties(source, target, null);
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) throws IllegalArgumentException, BeansException {
        Assert.notNull(source, "source must not be null");
        Assert.notNull(target, "source must not be null");
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        BeanWrapperImpl sourceBw = new BeanWrapperImpl(source);
        BeanWrapperImpl targetBw = new BeanWrapperImpl(target);
        MutablePropertyValues values = new MutablePropertyValues();
        for (int i = 0; i < sourceBw.getPropertyDescriptors().length; ++i) {
            PropertyDescriptor targetDesc;
            PropertyDescriptor sourceDesc = sourceBw.getPropertyDescriptors()[i];
            String name = sourceDesc.getName();
            if (ignoreProperties != null && ignoreList.contains(name) || (targetDesc = targetBw.getPropertyDescriptor(name)).getWriteMethod() == null || targetDesc.getReadMethod() == null) continue;
            values.addPropertyValue(new PropertyValue(name, sourceBw.getPropertyValue(name)));
        }
        targetBw.setPropertyValues(values);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz);
        return cr.getBeanInfo().getPropertyDescriptors();
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        Assert.notNull(method, "method must not be null");
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(method.getDeclaringClass());
        for (int i = 0; i < pds.length; ++i) {
            if (!method.equals(pds[i].getReadMethod()) && !method.equals(pds[i].getWriteMethod())) continue;
            return pds[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveWrapperTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanUtils.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = BeanUtils.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = BeanUtils.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtils.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = BeanUtils.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = BeanUtils.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = BeanUtils.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
    }
}

