/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.api;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.idealstate.hyper.command.api.Command;
import team.idealstate.hyper.command.api.CommandContext;
import team.idealstate.hyper.command.api.framework.CommandHandler;
import team.idealstate.hyper.command.spi.CommandContextFactory;
import team.idealstate.hyper.command.spi.CommandFactory;
import team.idealstate.hyper.commons.base.AssertUtils;

public abstract class FastCommand {
    private static final CommandContextFactory COMMAND_CONTEXT_FACTORY;
    private static final CommandFactory COMMAND_FACTORY;

    @NotNull
    public static CommandContext currentContext() {
        return COMMAND_CONTEXT_FACTORY.createCommandContext();
    }

    @NotNull
    public static Command root(String description) {
        return COMMAND_FACTORY.createRootCommand(description);
    }

    @NotNull
    public static Command command(String description) {
        return COMMAND_FACTORY.createCommand(description);
    }

    @NotNull
    public static Command command(@NotNull Class<? extends CommandHandler> commandHandlerClass) {
        return COMMAND_FACTORY.createCommand(commandHandlerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<String> complete(@NotNull Command command, String[] args) {
        AssertUtils.notNull((Object)command, (String)"\u65e0\u6548\u7684\u547d\u4ee4");
        CommandContext currentContext = null;
        try {
            Command acceptedCommand;
            args = Command.promise(args);
            currentContext = FastCommand.currentContext();
            for (int i = 0; i < args.length && (acceptedCommand = command.accept(currentContext, args)) != null; ++i) {
                command = acceptedCommand;
            }
            List<String> list = command.complete(currentContext, args);
            return list;
        }
        finally {
            if (currentContext != null) {
                currentContext.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Boolean execute(@NotNull Command command, String[] args) {
        AssertUtils.notNull((Object)command, (String)"\u65e0\u6548\u7684\u547d\u4ee4");
        CommandContext currentContext = null;
        try {
            args = Command.promise(args);
            currentContext = FastCommand.currentContext();
            for (int i = 0; i < args.length && (command = command.accept(currentContext, args)) != null; ++i) {
            }
            Boolean executed = null;
            if (command != null) {
                executed = command.execute(currentContext, args);
            }
            Boolean bl = executed;
            return bl;
        }
        finally {
            if (currentContext != null) {
                currentContext.reset();
            }
        }
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader<CommandContextFactory> commandContextFactoryServiceLoader = ServiceLoader.load(CommandContextFactory.class, contextClassLoader);
        Iterator<CommandContextFactory> commandContextFactoryIterator = commandContextFactoryServiceLoader.iterator();
        if (!commandContextFactoryIterator.hasNext()) {
            throw new IllegalStateException("\u672a\u627e\u5230 CommandContextFactory \u7684\u5b9e\u73b0");
        }
        COMMAND_CONTEXT_FACTORY = commandContextFactoryIterator.next();
        ServiceLoader<CommandFactory> commandFactoryServiceLoader = ServiceLoader.load(CommandFactory.class, contextClassLoader);
        Iterator<CommandFactory> commandFactoryIterator = commandFactoryServiceLoader.iterator();
        if (!commandFactoryIterator.hasNext()) {
            throw new IllegalStateException("\u672a\u627e\u5230 CommandFactory \u7684\u5b9e\u73b0");
        }
        COMMAND_FACTORY = commandFactoryIterator.next();
    }
}

