/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.api.framework;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.idealstate.hyper.command.api.CommandContext;
import team.idealstate.hyper.command.api.framework.ArgumentConvertor;
import team.idealstate.hyper.command.api.framework.convert.BigDecimalConvertor;
import team.idealstate.hyper.command.api.framework.convert.BigIntegerConvertor;
import team.idealstate.hyper.command.api.framework.convert.BooleanConvertor;
import team.idealstate.hyper.command.api.framework.convert.ByteConvertor;
import team.idealstate.hyper.command.api.framework.convert.CharacterConvertor;
import team.idealstate.hyper.command.api.framework.convert.DoubleConvertor;
import team.idealstate.hyper.command.api.framework.convert.FloatConvertor;
import team.idealstate.hyper.command.api.framework.convert.IntegerConvertor;
import team.idealstate.hyper.command.api.framework.convert.LongConvertor;
import team.idealstate.hyper.command.api.framework.convert.ShortConvertor;
import team.idealstate.hyper.command.api.framework.convert.StringConvertor;
import team.idealstate.hyper.commons.base.AssertUtils;

public abstract class StandardConvertors {
    private static final Map<Class, ArgumentConvertor> CONVERTORS;

    @Nullable
    public static <R> R convert(@NotNull CommandContext context, @NotNull String argument, @NotNull Class<R> argumentType) throws Throwable {
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        AssertUtils.notBlank((CharSequence)argument, (String)"\u65e0\u6548\u7684\u53c2\u6570");
        AssertUtils.notNull(argumentType, (String)"\u65e0\u6548\u7684\u53c2\u6570\u7c7b\u578b");
        ArgumentConvertor<R> convertor = StandardConvertors.findArgumentConvertor(argumentType);
        if (convertor == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b: " + argumentType.getName());
        }
        return convertor.convert(context, argument);
    }

    @Nullable
    public static <R> ArgumentConvertor<R> findArgumentConvertor(@NotNull Class<R> argumentType) {
        AssertUtils.notNull(argumentType, (String)"\u65e0\u6548\u7684\u53c2\u6570\u7c7b\u578b");
        return CONVERTORS.get(argumentType);
    }

    static {
        HashMap<Class, ArgumentConvertor<Byte>> map = new HashMap<Class, ArgumentConvertor<Byte>>(19);
        ByteConvertor byteConvertor = new ByteConvertor();
        map.put(Byte.TYPE, byteConvertor);
        map.put(Byte.class, byteConvertor);
        ShortConvertor shortConvertor = new ShortConvertor();
        map.put(Short.TYPE, shortConvertor);
        map.put(Short.class, shortConvertor);
        IntegerConvertor integerConvertor = new IntegerConvertor();
        map.put(Integer.TYPE, integerConvertor);
        map.put(Integer.class, integerConvertor);
        LongConvertor longConvertor = new LongConvertor();
        map.put(Long.TYPE, longConvertor);
        map.put(Long.class, longConvertor);
        FloatConvertor floatConvertor = new FloatConvertor();
        map.put(Float.TYPE, floatConvertor);
        map.put(Float.class, floatConvertor);
        DoubleConvertor doubleConvertor = new DoubleConvertor();
        map.put(Double.TYPE, doubleConvertor);
        map.put(Double.class, doubleConvertor);
        BooleanConvertor booleanConvertor = new BooleanConvertor();
        map.put(Boolean.TYPE, booleanConvertor);
        map.put(Boolean.class, booleanConvertor);
        CharacterConvertor characterConvertor = new CharacterConvertor();
        map.put(Character.TYPE, characterConvertor);
        map.put(Character.class, characterConvertor);
        map.put(String.class, new StringConvertor());
        map.put(BigDecimal.class, new BigDecimalConvertor());
        map.put(BigInteger.class, new BigIntegerConvertor());
        CONVERTORS = Collections.unmodifiableMap(map);
    }
}

