/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.idealstate.hyper.command.api.Command;
import team.idealstate.hyper.command.api.CommandContext;
import team.idealstate.hyper.commons.base.AssertUtils;

public class CommandContextImpl
implements CommandContext {
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>(16, 0.6f);
    private String[] arguments = Command.EMPTY_ARGS;
    private int depth = -1;

    @Nullable
    public Object put(@NotNull String key, @NotNull Object value) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        AssertUtils.notNull((Object)value, (String)"\u65e0\u6548\u7684\u503c");
        return this.valueMap.put(key, value);
    }

    @Nullable
    public Object remove(@NotNull String key) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        return this.valueMap.remove(key);
    }

    @Nullable
    public <T> T remove(@NotNull String key, @NotNull Class<T> valueType) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        AssertUtils.notNull(valueType, (String)"\u65e0\u6548\u7684\u503c\u7c7b\u578b");
        if (this.valueMap.containsKey(key) && valueType.isInstance(this.valueMap.get(key))) {
            return valueType.cast(this.valueMap.remove(key));
        }
        return null;
    }

    @NotNull
    public Set<String> getKeys() {
        if (this.valueMap.isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(this.valueMap.keySet());
    }

    public boolean hasKey(@NotNull String key) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        return this.valueMap.containsKey(key);
    }

    public boolean hasValue(@NotNull String key) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        return this.valueMap.get(key) != null;
    }

    @Nullable
    public Object getValue(@NotNull String key) {
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        return this.valueMap.get(key);
    }

    @Nullable
    public <T> T getValue(@NotNull String key, @NotNull Class<T> valueType) {
        Object valueObject;
        AssertUtils.notBlank((CharSequence)key, (String)"\u65e0\u6548\u7684\u952e");
        AssertUtils.notNull(valueType, (String)"\u65e0\u6548\u7684\u503c\u7c7b\u578b");
        if (this.valueMap.containsKey(key) && valueType.isInstance(valueObject = this.valueMap.get(key))) {
            return valueType.cast(valueObject);
        }
        return null;
    }

    @NotNull
    public String getArgument() {
        return this.arguments[this.depth];
    }

    public void clear() {
        this.valueMap.clear();
    }

    public void reset() {
        this.clear();
        this.arguments = Command.EMPTY_ARGS;
        this.depth = -1;
    }

    @NotNull
    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = Command.promise((String[])arguments);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < 0 || depth >= this.arguments.length) {
            throw new IllegalArgumentException("depth \u7684\u503c\u5fc5\u987b\u4ecb\u4e8e 0 \u548c " + this.arguments.length + "\u4e4b\u95f4");
        }
        this.depth = depth;
    }
}

