/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.provider;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import team.idealstate.hyper.command.api.Command;
import team.idealstate.hyper.command.api.FastCommand;
import team.idealstate.hyper.command.api.framework.ArgumentConvertor;
import team.idealstate.hyper.command.api.framework.CommandHandler;
import team.idealstate.hyper.command.api.framework.annotation.RootCommand;
import team.idealstate.hyper.command.api.framework.annotation.SubCommand;
import team.idealstate.hyper.command.impl.CommandImpl;
import team.idealstate.hyper.command.impl.argument.AcceptorUtils;
import team.idealstate.hyper.command.impl.example.ExampleUtils;
import team.idealstate.hyper.command.spi.CommandFactory;
import team.idealstate.hyper.commons.base.AssertUtils;
import team.idealstate.hyper.commons.base.StringUtils;

public final class DefaultCommandFactory
implements CommandFactory {
    private static final Logger logger = LogManager.getLogger(DefaultCommandFactory.class);

    @NotNull
    public Command createRootCommand(String description) {
        CommandImpl command = new CommandImpl(description);
        command.setParent(null);
        return command;
    }

    @NotNull
    public Command createCommand(String description) {
        return new CommandImpl(description);
    }

    private static boolean isToken(@NotNull String token) {
        return token.startsWith("${") && token.endsWith("}");
    }

    private static String token(@NotNull String tokenName) {
        return "${" + tokenName + "}";
    }

    private static String tokenName(@NotNull String token) {
        return token.substring(2, token.length() - 1);
    }

    @NotNull
    public Command createCommand(@NotNull Class<? extends CommandHandler> commandHandlerClass) {
        CommandHandler commandHandler;
        AssertUtils.notNull(commandHandlerClass, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u5904\u7406\u5668\u7c7b\u578b");
        RootCommand rootCommand = commandHandlerClass.getDeclaredAnnotation(RootCommand.class);
        String commandHandlerClassName = commandHandlerClass.getName();
        if (rootCommand == null) {
            throw new IllegalStateException("\u672a\u6807\u8bb0 @RootCommand \u7684\u547d\u4ee4\u5904\u7406\u5668\u7c7b\u578b " + commandHandlerClassName);
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle constructor = lookup.findConstructor(commandHandlerClass, MethodType.methodType(Void.TYPE));
            commandHandler = constructor.invoke();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        String rootDescription = rootCommand.value();
        Command root = FastCommand.command((String)rootDescription).exampleProvider(ExampleUtils.singleton(rootDescription)).argumentAcceptor(AcceptorUtils.isEquals(rootDescription));
        for (Method method : commandHandlerClass.getDeclaredMethods()) {
            MethodHandle methodHandle;
            String[] arguments;
            String expression;
            SubCommand subCommand;
            if (!Modifier.isPublic(method.getModifiers()) || (subCommand = method.getDeclaredAnnotation(SubCommand.class)) == null || StringUtils.isBlank((CharSequence)(expression = subCommand.value()))) continue;
            if (!Boolean.TYPE.equals(method.getReturnType())) {
                logger.error("\u65e0\u6548\u7684\u5b50\u547d\u4ee4\u65b9\u6cd5\u8fd4\u56de\u503c {}#{}", (Object)commandHandlerClassName, (Object)method.getName());
                continue;
            }
            Parameter[] parameters = method.getParameters();
            HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>(parameters.length);
            for (Parameter parameter : parameters) {
                parameterMap.put(parameter.getName(), parameter);
            }
            Command parent = null;
            for (String token : arguments = expression.split(" ", -1)) {
                Command command = FastCommand.command((String)token);
                if (parent == null) {
                    root.subCommand(command);
                } else {
                    parent.subCommand(command);
                }
                parent = command;
                if (DefaultCommandFactory.isToken(token)) {
                    String tokenName = DefaultCommandFactory.tokenName(token);
                    command.argumentAcceptor(context -> {
                        String argument = context.getArgument();
                        Parameter parameter = (Parameter)parameterMap.get(tokenName);
                        if (parameter != null) {
                            Object converted;
                            Class<?> type = parameter.getType();
                            ArgumentConvertor argumentConvertor = commandHandler.findArgumentConvertor(type);
                            String typeName = type.getName();
                            if (argumentConvertor == null) {
                                logger.debug("[Command]({}) \u53c2\u6570\u8f6c\u6362\uff1a\u672a\u627e\u5230\u4e0e\u53c2\u6570\u7c7b\u578b {} \u5339\u914d\u7684\u8f6c\u6362\u5668", (Object)token, (Object)typeName);
                                return false;
                            }
                            try {
                                converted = argumentConvertor.convert(context, argument);
                            }
                            catch (Throwable e) {
                                logger.debug("[Command]({}) \u53c2\u6570\u8f6c\u6362\uff1a\u65e0\u6cd5\u5c06\u53c2\u6570\u503c '{}' \u8f6c\u6362\u4e3a {} \u7c7b\u578b\u503c", (Object)token, (Object)argument, (Object)typeName);
                                logger.debug("catching", e);
                                return false;
                            }
                            context.put(token, converted);
                            return true;
                        }
                        logger.debug("[Command]({}) \u53c2\u6570\u8f6c\u6362\uff1a\u672a\u627e\u5230\u4e0e\u547d\u4ee4\u53c2\u6570 '{}' \u5339\u914d\u7684\u65b9\u6cd5\u53c2\u6570", (Object)token, (Object)tokenName);
                        return false;
                    });
                    continue;
                }
                command.exampleProvider(ExampleUtils.singleton(token)).argumentAcceptor(AcceptorUtils.isEquals(token));
            }
            if (parent == null) {
                throw new IllegalStateException("\u65e0\u6548\u7684\u5b50\u547d\u4ee4\u8868\u8fbe\u5f0f " + expression);
            }
            try {
                methodHandle = lookup.unreflect(method).bindTo(commandHandler);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            parent.commandExecutor(context -> {
                Object[] argumentObjects = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    argumentObjects[i] = context.getValue(DefaultCommandFactory.token(parameter.getName()), parameter.getType());
                }
                try {
                    return (Boolean)methodHandle.invokeWithArguments(argumentObjects);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return root;
    }
}

