/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.ExternalEvent;
import tech.deplant.java4ever.binding.ffi.EverSdkBridge;

public final class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private final int id;
    private final ObjectMapper mapper;
    private final long timeout;
    private int requestCount;

    public Context(int id, int requestCount, long timeout, ObjectMapper mapper) {
        this.id = id;
        this.requestCount = requestCount;
        this.timeout = timeout;
        this.mapper = mapper;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public long timeout() {
        return this.timeout;
    }

    public <T, P, A> T callAppObject(String functionName, P params, A appObject, Class<T> clazz) throws EverSdkException {
        return this.call(functionName, params, clazz);
    }

    public <T, P, E extends ExternalEvent> T callEvent(String functionName, P params, Consumer<E> consumer, Class<T> clazz) throws EverSdkException {
        return this.call(functionName, params, clazz);
    }

    public <T, P> T call(String functionName, P params, Class<T> clazz) throws EverSdkException {
        try {
            return (T)this.mapper.readValue(this.processRequest(functionName, this.processParams(params)), clazz);
        }
        catch (JsonProcessingException e) {
            log.error("Successful response deserialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-500, "Successful response deserialization failed! Check getCause() for actual response."), (Throwable)e);
        }
    }

    public <P> void callVoid(String functionName, P params) throws EverSdkException {
        this.processRequest(functionName, this.processParams(params));
    }

    private <P> String processParams(P params) throws EverSdkException {
        try {
            return null == params ? "" : this.mapper.writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            log.error("Parameters serialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-501, "Parameters serialization failed!"), (Throwable)e);
        }
    }

    private String processRequest(String functionName, String params) throws EverSdkException {
        ++this.requestCount;
        try {
            log.trace("FUNC:" + functionName + " CTXID:" + this.id() + " REQID:" + this.requestCount() + " SEND:" + params);
            String result = EverSdkBridge.tcRequest(this.id(), this.requestCount(), functionName, params).result().get(this.timeout, TimeUnit.MILLISECONDS);
            log.trace("FUNC: " + functionName + " CTXID:" + this.id() + " REQID:" + this.requestCount() + " RESP:" + result);
            return result;
        }
        catch (CompletionException | ExecutionException e) {
            EverSdkException.ErrorResult sdkResponse = null;
            try {
                sdkResponse = (EverSdkException.ErrorResult)this.mapper.readValue(e.getCause().getMessage(), EverSdkException.ErrorResult.class);
                log.warn("Error from SDK. Code: " + sdkResponse.code() + ", Message: " + sdkResponse.message());
                throw new EverSdkException(sdkResponse, (Throwable)e);
            }
            catch (JsonProcessingException ex) {
                log.error("SDK Error Response deserialization failed! Response: " + e.getCause().getMessage() + ex.getMessage());
                throw new EverSdkException(new EverSdkException.ErrorResult(-500, "SDK Error Response deserialization failed! Check getCause() for actual response."), (Throwable)ex);
            }
        }
        catch (InterruptedException e) {
            log.error("EVER-SDK call interrupted!" + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-400, "EVER-SDK call interrupted!"), (Throwable)e);
        }
        catch (TimeoutException e) {
            log.error("EVER-SDK Execution expired on Timeout! Current timeout: " + this.timeout + " Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-402, "EVER-SDK Execution expired on Timeout! Current timeout: " + this.timeout), (Throwable)e);
        }
    }

    public int id() {
        return this.id;
    }

    public int requestCount() {
        return this.requestCount;
    }
}

