/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import tech.deplant.java4ever.binding.ffi.tc_string_data_t;

public class EverSdkUtils {
    public static String toJavaString(MemorySegment segment, int len) {
        byte[] bytes = new byte[len];
        MemorySegment.copy(segment, ValueLayout.JAVA_BYTE, 0L, bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String toJavaString(MemorySegment seg, MemorySession scope) {
        if (tc_string_data_t.len$get(seg) > 0) {
            MemoryAddress addr = tc_string_data_t.content$get(seg);
            byte[] str = MemorySegment.ofAddress((MemoryAddress)addr, (long)tc_string_data_t.len$get(seg), (MemorySession)scope).toArray(ValueLayout.JAVA_BYTE);
            return new String(str, StandardCharsets.UTF_8);
        }
        return "";
    }

    static int strLength(MemorySegment seg) {
        return tc_string_data_t.len$get(seg);
    }

    static MemorySegment fromJavaString(SegmentAllocator allocator, String s, Charset charset) {
        if (StandardCharsets.UTF_8 == charset) {
            return allocator.allocateUtf8String(s);
        }
        return allocator.allocateArray(ValueLayout.JAVA_BYTE, (s + "\u0000").getBytes(charset));
    }
}

