/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Client {
    public static ResultOfGetApiReference getApiReference(Context ctx) throws EverSdkException {
        return ctx.call("client.get_api_reference", null, ResultOfGetApiReference.class);
    }

    public static ResultOfVersion version(Context ctx) throws EverSdkException {
        return ctx.call("client.version", null, ResultOfVersion.class);
    }

    public static ClientConfig config(Context ctx) throws EverSdkException {
        return ctx.call("client.config", null, ClientConfig.class);
    }

    public static ResultOfBuildInfo buildInfo(Context ctx) throws EverSdkException {
        return ctx.call("client.build_info", null, ResultOfBuildInfo.class);
    }

    public static void resolveAppRequest(Context ctx, Integer appRequestId, AppRequestResult result) throws EverSdkException {
        ctx.callVoid("client.resolve_app_request", new ParamsOfResolveAppRequest(appRequestId, result));
    }

    public record ResultOfGetApiReference(Map<String, Object> api) {
    }

    public record ResultOfVersion(String version) {
    }

    public record ClientConfig(BindingConfig binding, NetworkConfig network, CryptoConfig crypto, AbiConfig abi, BocConfig boc, ProofsConfig proofs, String localStoragePath) {
    }

    public record ResultOfBuildInfo(Integer buildNumber, BuildInfoDependency[] dependencies) {
    }

    public record ParamsOfResolveAppRequest(Integer appRequestId, AppRequestResult result) {
    }

    public static sealed interface AppRequestResult {

        public record Ok(Map<String, Object> result) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return "Ok";
            }
        }

        public record Error(String text) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return "Error";
            }
        }
    }

    public record CryptoConfig(Crypto.MnemonicDictionary mnemonicDictionary, Integer mnemonicWordCount, String hdkeyDerivationPath) {
    }

    public static enum NetworkQueriesProtocol {
        HTTP,
        WS;

    }

    public record BocConfig(Integer cacheMaxSize) {
    }

    public record ParamsOfAppRequest(Integer appRequestId, Map<String, Object> requestData) {
    }

    public record NetworkConfig(String serverAddress, String[] endpoints, Integer networkRetriesCount, Integer maxReconnectTimeout, Integer reconnectTimeout, Integer messageRetriesCount, Integer messageProcessingTimeout, Integer waitForTimeout, Integer outOfSyncThreshold, Integer sendingEndpointCount, Integer latencyDetectionInterval, Integer maxLatency, Integer queryTimeout, NetworkQueriesProtocol queriesProtocol, Integer firstRempStatusTimeout, Integer nextRempStatusTimeout, Integer signatureId, String accessKey) {
    }

    public record ClientError(Integer code, String message, Map<String, Object> data) {
    }

    public record ProofsConfig(Boolean cacheInLocalStorage) {
    }

    public record BindingConfig(String library, String version) {
    }

    public record BuildInfoDependency(String name, String gitCommit) {
    }

    public record AbiConfig(Integer workchain, Integer messageExpirationTimeout, Integer messageExpirationTimeoutGrowFactor) {
    }

    public static enum ClientErrorCode {
        NotImplemented(1),
        InvalidHex(2),
        InvalidBase64(3),
        InvalidAddress(4),
        CallbackParamsCantBeConvertedToJson(5),
        WebsocketConnectError(6),
        WebsocketReceiveError(7),
        WebsocketSendError(8),
        HttpClientCreateError(9),
        HttpRequestCreateError(10),
        HttpRequestSendError(11),
        HttpRequestParseError(12),
        CallbackNotRegistered(13),
        NetModuleNotInit(14),
        InvalidConfig(15),
        CannotCreateRuntime(16),
        InvalidContextHandle(17),
        CannotSerializeResult(18),
        CannotSerializeError(19),
        CannotConvertJsValueToJson(20),
        CannotReceiveSpawnedResult(21),
        SetTimerError(22),
        InvalidParams(23),
        ContractsAddressConversionFailed(24),
        UnknownFunction(25),
        AppRequestError(26),
        NoSuchRequest(27),
        CanNotSendRequestResult(28),
        CanNotReceiveRequestResult(29),
        CanNotParseRequestResult(30),
        UnexpectedCallbackResponse(31),
        CanNotParseNumber(32),
        InternalError(33),
        InvalidHandle(34),
        LocalStorageError(35),
        InvalidData(36);

        private final Integer value;

        private ClientErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }
}

