/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Solc {
    @Generated
    private static final Logger log = LogManager.getLogger(Solc.class);
    private final String DEFAULT_SOL_EXTENSION = ".sol";
    private final String compilerPath;

    public Solc(String path) {
        if (!Files.exists(Path.of(path, new String[0]), new LinkOption[0]) && !Files.exists(Path.of(path + ".exe", new String[0]), new LinkOption[0])) {
            log.error("ERROR! Compiler executable not found at specified path!");
            throw new RuntimeException();
        }
        this.compilerPath = path;
    }

    public void compileContract(String contractName, String sourceFolder, String outputFolder) {
        this.compileContract(contractName, contractName + ".sol", sourceFolder, outputFolder);
    }

    public CompletableFuture<Process> compileContract(String contractName, String sourceFileName, String sourceFolder, String outputFolder) {
        File sourceFolderFile = null;
        if (Files.isDirectory(Path.of(sourceFolder, new String[0]), new LinkOption[0])) {
            sourceFolderFile = new File(sourceFolder);
        } else {
            log.error("ERROR! Source path is not a folder!");
        }
        if (!Files.isDirectory(Path.of(outputFolder, new String[0]), new LinkOption[0])) {
            log.error("ERROR! Output path is not a folder!");
        }
        if (!Files.exists(Path.of(sourceFolder + "/" + sourceFileName, new String[0]), new LinkOption[0])) {
            log.error("ERROR! No such contract file in source folder!");
        }
        try {
            log.info("Begging compilation of Solidity source...");
            Process p = new ProcessBuilder(new String[0]).inheritIO().directory(sourceFolderFile).command(this.compilerPath, sourceFileName, "--output-dir", outputFolder, "-c", contractName).start();
            return p.onExit();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return CompletableFuture.failedFuture(new RuntimeException(e.getMessage()));
        }
    }

    @Generated
    public String DEFAULT_SOL_EXTENSION() {
        return this.DEFAULT_SOL_EXTENSION;
    }

    @Generated
    public String compilerPath() {
        return this.compilerPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Solc)) {
            return false;
        }
        Solc other = (Solc)o;
        String this$DEFAULT_SOL_EXTENSION = this.DEFAULT_SOL_EXTENSION();
        String other$DEFAULT_SOL_EXTENSION = other.DEFAULT_SOL_EXTENSION();
        if (this$DEFAULT_SOL_EXTENSION == null ? other$DEFAULT_SOL_EXTENSION != null : !this$DEFAULT_SOL_EXTENSION.equals(other$DEFAULT_SOL_EXTENSION)) {
            return false;
        }
        String this$compilerPath = this.compilerPath();
        String other$compilerPath = other.compilerPath();
        return !(this$compilerPath == null ? other$compilerPath != null : !this$compilerPath.equals(other$compilerPath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $DEFAULT_SOL_EXTENSION = this.DEFAULT_SOL_EXTENSION();
        result = result * 59 + ($DEFAULT_SOL_EXTENSION == null ? 43 : $DEFAULT_SOL_EXTENSION.hashCode());
        String $compilerPath = this.compilerPath();
        result = result * 59 + ($compilerPath == null ? 43 : $compilerPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Solc(DEFAULT_SOL_EXTENSION=" + this.DEFAULT_SOL_EXTENSION() + ", compilerPath=" + this.compilerPath() + ")";
    }
}

