/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.artifact;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.ContractTvc;
import tech.deplant.java4ever.framework.FileData;
import tech.deplant.java4ever.framework.artifact.Artifact;

public record FileArtifact(Path path) implements Artifact
{
    @Generated
    private static final Logger log = LogManager.getLogger(FileArtifact.class);

    public static FileArtifact ofResourcePath(String resourcePath) {
        Object cleanedPath = FileArtifact.processPath(resourcePath);
        if (((String)cleanedPath).length() > 0 && !"/".equals(((String)cleanedPath).substring(0, 1))) {
            cleanedPath = "/" + (String)cleanedPath;
        }
        if (((String)cleanedPath).length() > 0 && !".".equals(((String)cleanedPath).substring(0, 1))) {
            cleanedPath = "." + (String)cleanedPath;
        }
        log.trace("Accessing file:" + (String)cleanedPath);
        try {
            return new FileArtifact(Paths.get(FileData.class.getClassLoader().getResource((String)cleanedPath).toURI()));
        }
        catch (NullPointerException | URISyntaxException e) {
            log.error("Wrong path: Path: " + (String)cleanedPath + ", Error: " + e.getMessage());
            return null;
        }
    }

    public static FileArtifact ofAbsolutePath(String absolutePath) {
        String cleanedPath = FileArtifact.processPath(absolutePath);
        log.trace("Accessing file:" + cleanedPath);
        return new FileArtifact(Paths.get(cleanedPath, new String[0]));
    }

    private static String processPath(String providedPath) {
        return providedPath.replace(File.separator, "/");
    }

    @Override
    public byte[] getAsBytes() {
        try {
            return Files.readAllBytes(this.path);
        }
        catch (IOException e) {
            log.error("File access error! Path: " + this.path + ", Error: " + e.getMessage());
            return new byte[0];
        }
    }

    @Override
    public String getAsString() {
        try {
            return Files.readString(this.path);
        }
        catch (IOException e) {
            log.error("File access error! Path: " + this.path + ", Error: " + e.getMessage());
            return "";
        }
    }

    @Override
    public String getAsJsonString() {
        return this.getAsString().replaceAll("[\u0000-\u001f]", "");
    }

    @Override
    public String getAsBase64String() {
        return Base64.getEncoder().encodeToString(this.getAsBytes());
    }

    @Override
    public ContractAbi getAsABI() {
        return new ContractAbi(this.getAsJsonString());
    }

    @Override
    public ContractTvc getAsTVC() {
        return new ContractTvc(this.getAsBase64String());
    }
}

