/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.abi;

import java.math.BigInteger;
import java.time.Instant;
import tech.deplant.java4ever.framework.abi.AbiValue;

public record AbiUint(int size, BigInteger bigInteger) implements AbiValue
{
    public AbiUint(BigInteger bigValue) {
        this(256, bigValue);
    }

    public AbiUint(Integer intValue) {
        this(256, BigInteger.valueOf(intValue.intValue()));
    }

    public AbiUint(Long longVal) {
        this(256, BigInteger.valueOf(longVal));
    }

    public AbiUint(Instant instant) {
        this(instant.getEpochSecond());
    }

    public static BigInteger deserialize(int size, Object obj) {
        String str = obj.toString();
        if (str.startsWith("0x")) {
            str = str.substring(2);
        }
        return new BigInteger(str, 16);
    }

    @Override
    public Object serialize() {
        return "0x" + this.bigInteger().toString(16);
    }
}

