/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.abi.datatype;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.datatype.AbiType;
import tech.deplant.java4ever.framework.abi.datatype.Address;
import tech.deplant.java4ever.framework.abi.datatype.ByteString;
import tech.deplant.java4ever.framework.abi.datatype.TvmCell;
import tech.deplant.java4ever.framework.abi.datatype.TypePrefix;
import tech.deplant.java4ever.framework.abi.datatype.Uint;

public class TvmBuilder {
    private final AtomicInteger refCounter = new AtomicInteger(0);
    private final List<Boc.BuilderOp> operations = new ArrayList<Boc.BuilderOp>();

    public Boc.BuilderOp[] builders() {
        return (Boc.BuilderOp[])this.operations.toArray(Boc.BuilderOp[]::new);
    }

    public TvmBuilder store(AbiType type) throws EverSdkException {
        AbiType abiType = type;
        Objects.requireNonNull(abiType);
        AbiType abiType2 = abiType;
        int n = 0;
        this.operations.add((Boc.BuilderOp)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Uint.class, ByteString.class, Address.class, TvmBuilder.class}, (Object)abiType2, n)) {
            case 0 -> {
                Uint intVal = (Uint)abiType2;
                yield new Boc.BuilderOp.Integer(Integer.valueOf(intVal.size()), intVal.toABI());
            }
            case 1 -> {
                ByteString str = (ByteString)abiType2;
                yield new Boc.BuilderOp.BitString(str.toABI());
            }
            case 2 -> {
                Address addr = (Address)abiType2;
                yield new Boc.BuilderOp.Address(addr.toABI());
            }
            case 3 -> {
                TvmBuilder builder = (TvmBuilder)((Object)abiType2);
                int refCount = this.refCounter.incrementAndGet();
                if (refCount > 4) {
                    throw new EverSdkException(new EverSdkException.ErrorResult(-306, "TvmCell can't contain more than 4 references to other TvmCells"));
                }
                yield new Boc.BuilderOp.Cell(builder.builders());
            }
            default -> throw new EverSdkException(new EverSdkException.ErrorResult(-305, "Builder of TvmCell doesn't support this type for ABI conversion"), (Throwable)new Exception());
        }));
        return this;
    }

    public TvmBuilder store(TypePrefix prefix, int size, Object inputValue) throws EverSdkException {
        this.store(AbiType.of(prefix, size, inputValue));
        return this;
    }

    public TvmCell toCell(Sdk sdk) throws EverSdkException {
        return new TvmCell(Boc.encodeBoc((Context)sdk.context(), (Boc.BuilderOp[])this.builders(), null).boc());
    }
}

