/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.contract.Tip32Root;
import tech.deplant.java4ever.framework.crypto.Credentials;
import tech.deplant.java4ever.framework.template.ContractTemplate;
import tech.deplant.java4ever.framework.template.ContractTvc;
import tech.deplant.java4ever.framework.template.Tip31WalletTemplate;

public class Tip31RootTemplate
extends ContractTemplate {
    public static final ContractTvc DEFAULT_TVC = ContractTvc.ofResource("artifacts/tip31/TokenRoot.tvc");

    public Tip31RootTemplate() throws JsonProcessingException {
        super(Tip31RootTemplate.DEFAULT_ABI(), DEFAULT_TVC);
    }

    public Tip31RootTemplate(ContractAbi abi, ContractTvc tvc) {
        super(abi, tvc);
    }

    public static ContractAbi DEFAULT_ABI() throws JsonProcessingException {
        return ContractAbi.ofResource("artifacts/tip31/TokenRoot.abi.json");
    }

    public Tip32Root deployWithGiver(Sdk sdk, Credentials keys, Giver giver, BigInteger value, String tokenName, String tokenTicker, int tokenDecimalPoints, String rootOwner, BigInteger totalSupply, String deployer, String initialSupplyTo, BigInteger initialSupply, BigInteger initialWalletValue, boolean mintDisabled, boolean burnByRootDisabled, boolean burnPaused, String remainingGasTo) throws EverSdkException {
        Map<String, Object> initialData = Map.of("name_", tokenName, "symbol_", tokenTicker, "decimals_", tokenDecimalPoints, "rootOwner_", rootOwner, "walletCode_", Tip31WalletTemplate.DEFAULT_TVC.code(sdk), "totalSupply_", totalSupply, "randomNonce_", 0, "deployer_", deployer);
        Map<String, Object> constructorInputs = Map.of("initialSupplyTo", initialSupplyTo, "initialSupply", initialSupply, "deployWalletValue", initialWalletValue, "mintDisabled", mintDisabled, "burnByRootDisabled", burnByRootDisabled, "burnPaused", burnPaused, "remainingGasTo", remainingGasTo);
        OwnedContract contract = super.deployWithGiver(sdk, giver, value, 0, initialData, keys, constructorInputs);
        return new Tip32Root(contract);
    }
}

