/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.util.function.Supplier;
import tech.deplant.java4ever.binding.Net;

public class LogUtils {
    public static final String CALL_LOG_BLOCK = "\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n";

    public static String enquotedListAgg(String[] elements) {
        return "\"" + String.join((CharSequence)"\",\"", elements) + "\"";
    }

    public static String destOfMessage(Net.MessageNode messageNode) {
        return messageNode.dst().length() > 0 ? messageNode.dst() : "ext";
    }

    public static String sourceOfMessage(Net.MessageNode messageNode) {
        return messageNode.src().length() > 0 ? messageNode.src() : "ext";
    }

    public static String typeOfMessage(Net.MessageNode messageNode) {
        if (LogUtils.sourceOfMessage(messageNode) == "ext") {
            return "EXTERNAL CALL";
        }
        if (LogUtils.destOfMessage(messageNode) == "ext") {
            return "EVENT";
        }
        return "INTERNAL MSG";
    }

    public static String nameOfMessage(Net.MessageNode messageNode) {
        if (messageNode.decodedBody() == null || messageNode.decodedBody().name() == null) {
            return "Unknown";
        }
        return messageNode.decodedBody().name();
    }

    public static void trace(System.Logger logger, String message) {
        logger.log(System.Logger.Level.TRACE, () -> message);
    }

    public static void trace(System.Logger logger, Supplier<String> lazyMessage) {
        logger.log(System.Logger.Level.TRACE, lazyMessage);
    }

    public static void debug(System.Logger logger, String message) {
        logger.log(System.Logger.Level.DEBUG, () -> message);
    }

    public static void debug(System.Logger logger, Supplier<String> lazyMessage) {
        logger.log(System.Logger.Level.DEBUG, lazyMessage);
    }

    public static void info(System.Logger logger, String message) {
        logger.log(System.Logger.Level.INFO, () -> message);
    }

    public static void info(System.Logger logger, Supplier<String> lazyMessage) {
        logger.log(System.Logger.Level.INFO, lazyMessage);
    }

    public static void warn(System.Logger logger, String message) {
        logger.log(System.Logger.Level.WARNING, () -> message);
    }

    public static void warn(System.Logger logger, Supplier<String> lazyMessage) {
        logger.log(System.Logger.Level.WARNING, lazyMessage);
    }

    public static void error(System.Logger logger, String message) {
        logger.log(System.Logger.Level.ERROR, () -> message);
    }

    public static void error(System.Logger logger, Supplier<String> lazyMessage) {
        logger.log(System.Logger.Level.ERROR, lazyMessage);
    }
}

