/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Convert;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.ResultOfTree;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;

public record FunctionHandle<RETURN>(Class<RETURN> clazz, Sdk sdk, String address, ContractAbi abi, Credentials credentials, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
    private static System.Logger logger = System.getLogger(FunctionHandle.class.getName());

    public FunctionHandle(Sdk sdk, String address, ContractAbi abi, Credentials credentials, String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        this(new HashMap().getClass(), sdk, address, abi, credentials, functionName, functionInputs, functionHeader);
    }

    public FunctionHandle<RETURN> withSdk(Sdk sdk) {
        return new FunctionHandle<RETURN>(this.clazz(), sdk, this.address(), this.abi(), this.credentials(), this.functionName(), this.functionInputs(), this.functionHeader());
    }

    public FunctionHandle<RETURN> withCredentials(Credentials credentials) {
        return new FunctionHandle<RETURN>(this.clazz(), this.sdk(), this.address(), this.abi(), credentials, this.functionName(), this.functionInputs(), this.functionHeader());
    }

    public FunctionHandle<RETURN> withFunctionInputs(Map<String, Object> functionInputs) {
        return new FunctionHandle<RETURN>(this.clazz(), this.sdk(), this.address(), this.abi(), this.credentials(), this.functionName(), functionInputs, this.functionHeader());
    }

    public FunctionHandle<RETURN> withFunctionHeader(Abi.FunctionHeader functionHeader) {
        return new FunctionHandle<RETURN>(this.clazz(), this.sdk(), this.address(), this.abi(), this.credentials(), this.functionName(), this.functionInputs(), functionHeader);
    }

    public <T> FunctionHandle<T> withReturnClass(Class<T> returnClass) {
        return new FunctionHandle<T>(returnClass, this.sdk(), this.address(), this.abi(), this.credentials(), this.functionName(), this.functionInputs(), this.functionHeader());
    }

    public Abi.CallSet toCallSet() throws EverSdkException {
        Map<String, Object> converted = this.abi().convertFunctionInputs(this.functionName(), this.functionInputs());
        return new Abi.CallSet(this.functionName(), this.functionHeader(), converted);
    }

    public RETURN toOutput(Map<String, Object> outputMap) throws EverSdkException {
        Map<String, Object> converted = this.abi().convertFunctionOutputs(this.functionName(), outputMap);
        try {
            JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModules(new Module[]{new ParameterNamesModule(), new Jdk8Module(), new JavaTimeModule()})).build();
            String jsonStr = mapper.writeValueAsString(converted);
            return (RETURN)mapper.readValue(jsonStr, this.clazz());
        }
        catch (Throwable e) {
            try {
                LogUtils.trace(logger, String.format("Original: %s, Converted: %s", this.sdk().mapper().writeValueAsString(outputMap), this.sdk().mapper().writeValueAsString(converted)));
                throw new RuntimeException(e);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public TvmCell toPayload() throws EverSdkException {
        return TvmCell.fromJava(Abi.encodeMessageBody((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (Abi.CallSet)this.toCallSet(), (Boolean)true, (Abi.Signer)this.toSigner(), null, (String)this.address(), null).body());
    }

    public Abi.Signer toSigner() {
        return Objects.requireNonNullElse(this.credentials(), Credentials.NONE).signer();
    }

    public Map<String, Object> getAsMap() throws EverSdkException {
        HashMap<String, Account.GraphQLFilter.In> filter = new HashMap<String, Account.GraphQLFilter.In>();
        filter.put("id", new Account.GraphQLFilter.In(new String[]{this.address()}));
        Net.ResultOfQueryCollection result = Net.queryCollection((Context)this.sdk().context(), (String)"accounts", filter, (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_paid", null, null);
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (String)this.address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null);
        String boc = result.result()[0].get("boc").toString();
        Map resultMap = Optional.ofNullable(Tvm.runTvm((Context)this.sdk().context(), (String)msg.message(), (String)boc, null, (Abi.ABI)this.abi().ABI(), null, (Boolean)false).decoded().output()).orElse(new HashMap());
        return resultMap;
    }

    public RETURN get() throws EverSdkException {
        return this.toOutput(this.getAsMap());
    }

    public Map<String, Object> runLocalAsMap(String boc, Tvm.ExecutionOptions options, boolean unlimitedBalance) throws EverSdkException {
        Abi.ResultOfEncodeMessage msg = Abi.encodeMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (String)this.address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null);
        return Optional.ofNullable(Tvm.runExecutor((Context)this.sdk().context(), (String)msg.message(), (Tvm.AccountForExecutor)new Tvm.AccountForExecutor.Account(boc, Boolean.valueOf(unlimitedBalance)), (Tvm.ExecutionOptions)options, (Abi.ABI)this.abi().ABI(), (Boolean)false, null, (Boolean)true).decoded().output()).orElse(new HashMap());
    }

    public RETURN runLocal(String boc, Tvm.ExecutionOptions options, boolean unlimitedBalance) throws EverSdkException {
        return this.toOutput(this.runLocalAsMap(boc, options, unlimitedBalance));
    }

    public Map<String, Object> callAsMap() throws EverSdkException {
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall();
        BigDecimal balanceDeltaStr = Convert.hexToDec(resultOfProcess.transaction().get("balance_delta").toString(), 9);
        Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", "EXTERNAL CALL", this.functionName, resultOfProcess.transaction().get("id").toString(), resultOfProcess.transaction().get("in_msg").toString(), "ext", new BigDecimal(Uint.fromJava(128, resultOfProcess.fees().totalFwdFees()).toJava(), 9).toPlainString(), resultOfProcess.transaction().get("account_addr").toString(), 0, this.functionName, new BigDecimal(Uint.fromJava(128, resultOfProcess.fees().totalAccountFees()).toJava(), 9).toPlainString(), "");
        LogUtils.info(logger, lazyFormatLogMessage);
        return Optional.ofNullable(resultOfProcess.decoded().output()).orElse(new HashMap());
    }

    public RETURN call() throws EverSdkException {
        return this.toOutput(this.callAsMap());
    }

    public ResultOfTree<Map<String, Object>> callTreeAsMap(boolean throwOnTreeError, List<ContractAbi> otherAbisForDecode) throws EverSdkException {
        Abi.ABI[] abiArray = (Abi.ABI[])Stream.concat(Stream.of(this.abi()), otherAbisForDecode.stream()).map(ContractAbi::ABI).toArray(Abi.ABI[]::new);
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall();
        String msgId = resultOfProcess.transaction().get("in_msg").toString();
        Net.ResultOfQueryTransactionTree debugOutResult = Net.queryTransactionTree((Context)this.sdk().context(), (String)msgId, (Abi.ABI[])abiArray, (Integer)this.sdk().debugTreeTimeout(), (Integer)0);
        for (Net.TransactionNode tr : debugOutResult.transactions()) {
            Net.MessageNode msg = Arrays.stream(debugOutResult.messages()).filter(msgElem -> msgElem.id().equals(tr.inMsg())).findFirst().get();
            Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", LogUtils.typeOfMessage(msg), LogUtils.nameOfMessage(msg), tr.id(), msg.id(), LogUtils.sourceOfMessage(msg), Convert.hexToDecOrZero(msg.value(), 9).toPlainString(), LogUtils.destOfMessage(msg), (int)tr.exitCode(), LogUtils.nameOfMessage(msg), Convert.hexToDecOrZero(tr.totalFees(), 9).toPlainString(), LogUtils.enquotedListAgg(tr.outMsgs()));
            if (tr.aborted().booleanValue() && throwOnTreeError) {
                LogUtils.error(logger, lazyFormatLogMessage);
                throw new EverSdkException(new EverSdkException.ErrorResult(tr.exitCode().intValue(), "One of the message tree transaction was aborted!"), (Throwable)new Exception());
            }
            if (tr.aborted().booleanValue()) {
                LogUtils.warn(logger, lazyFormatLogMessage);
                continue;
            }
            LogUtils.info(logger, lazyFormatLogMessage);
        }
        Map map = Optional.ofNullable(resultOfProcess.decoded().output()).orElse(new HashMap());
        return new ResultOfTree<Map<String, Object>>(debugOutResult, map);
    }

    public ResultOfTree<RETURN> callTree(boolean throwOnTreeError, List<ContractAbi> otherAbisForDecode) throws EverSdkException {
        ResultOfTree<Map<String, Object>> result = this.callTreeAsMap(throwOnTreeError, otherAbisForDecode);
        return new ResultOfTree<RETURN>(result.queryTree(), this.toOutput(result.decodedOutput()));
    }

    private Processing.ResultOfProcessMessage processExternalCall() throws EverSdkException {
        return Processing.processMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (String)this.address(), null, (Abi.CallSet)this.toCallSet(), (Abi.Signer)this.toSigner(), null, null, (Boolean)false);
    }
}

