/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import jdk.incubator.concurrent.StructuredTaskScope;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.utils.Objs;

public record DeployHandle<RETURN>(Class<RETURN> clazz, Sdk sdk, ContractAbi abi, Tvc tvc, int workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader) {
    private static System.Logger logger = System.getLogger(DeployHandle.class.getName());
    private static JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModules(new Module[]{new ParameterNamesModule(), new Jdk8Module(), new JavaTimeModule()})).build();

    public <T> DeployHandle<T> withReturnClass(Class<T> returnClass) {
        return new DeployHandle<T>(returnClass, this.sdk(), this.abi(), this.tvc(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withConstructorHeader(Abi.FunctionHeader constructorHeader) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.abi(), this.tvc(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), constructorHeader);
    }

    public DeployHandle<RETURN> withConstructorInputs(Map<String, Object> constructorInputs) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.abi(), this.tvc(), this.workchainId(), this.credentials(), this.initialDataFields(), constructorInputs, this.constructorHeader());
    }

    public DeployHandle<RETURN> withInitDataFields(Map<String, Object> initialDataFields) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.abi(), this.tvc(), this.workchainId(), this.credentials(), initialDataFields, this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withCredentials(Credentials credentials) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.abi(), this.tvc(), this.workchainId(), credentials, this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public Abi.DeploySet toDeploySet() throws EverSdkException {
        return new Abi.DeploySet(this.tvc().base64String(), Integer.valueOf(this.workchainId()), this.abi().convertInitDataInputs(this.initialDataFields()), Objects.requireNonNullElse(this.credentials(), Credentials.NONE).publicKey());
    }

    public Abi.CallSet toConstructorCallSet() throws EverSdkException {
        return new Abi.CallSet("constructor", this.constructorHeader(), this.abi().convertFunctionInputs("constructor", this.constructorInputs()));
    }

    public Abi.Signer toSigner() {
        return ((Credentials)Objs.notNullElse((Object)this.credentials(), (Object)Credentials.NONE)).signer();
    }

    public String toAddress() throws EverSdkException {
        return Abi.encodeMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), null, (Abi.DeploySet)this.toDeploySet(), null, (Abi.Signer)this.toSigner(), null, null).address();
    }

    public RETURN deployWithGiver(Giver giver, BigInteger value) throws EverSdkException {
        String address = this.toAddress();
        giver.give(address, value).call();
        return this.deploy(address);
    }

    public RETURN deploy() throws EverSdkException {
        String address = this.toAddress();
        return this.deploy(address);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RETURN deploy(String address) throws EverSdkException {
        try (StructuredTaskScope.ShutdownOnFailure scope = new StructuredTaskScope.ShutdownOnFailure();){
            Future deploySetFuture = scope.fork(this::toDeploySet);
            Future callSetFuture = scope.fork(this::toConstructorCallSet);
            scope.join();
            Processing.processMessage((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (String)address, (Abi.DeploySet)((Abi.DeploySet)deploySetFuture.resultNow()), (Abi.CallSet)((Abi.CallSet)callSetFuture.resultNow()), (Abi.Signer)this.toSigner(), null, null, (Boolean)false);
            Map<String, Credentials> contractMap = Map.of("sdk", this.sdk(), "address", address, "abi", this.abi(), "credentials", this.credentials());
            RETURN RETURN = Contract.instantiate(this.clazz(), this.sdk(), address, this.abi(), this.credentials());
            return RETURN;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

