/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Seed;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.utils.Numbers;

public record Credentials(@JsonProperty(value="public") String publicKey, @JsonProperty(value="secret") String secretKey) {
    public static final Credentials NONE = new Credentials("0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000");

    public static Credentials RANDOM(Sdk sdk) throws EverSdkException {
        Crypto.KeyPair pair = Crypto.generateRandomSignKeys((EverSdkContext)sdk.context());
        return new Credentials(pair.publicKey(), pair.secretKey());
    }

    public static Credentials ofResource(String resourceName) {
        try {
            return (Credentials)EverSdkContext.Builder.DEFAULT_MAPPER.readValue(new JsonResource(resourceName).get(), Credentials.class);
        }
        catch (JsonProcessingException e) {
            return NONE;
        }
    }

    public static Credentials ofFile(String filePath) {
        try {
            return (Credentials)EverSdkContext.Builder.DEFAULT_MAPPER.readValue(new JsonFile(filePath).get(), Credentials.class);
        }
        catch (JsonProcessingException e) {
            return NONE;
        }
    }

    public static Credentials ofSeed(Sdk sdk, String seedString, int seedWords) throws EverSdkException {
        return Credentials.ofSeed(sdk, new Seed(seedString, seedWords));
    }

    public static Credentials ofSeed(Sdk sdk, Seed seed) throws EverSdkException {
        if (Crypto.mnemonicVerify((EverSdkContext)sdk.context(), (String)seed.phrase(), null, (Integer)seed.words()).valid().booleanValue()) {
            Crypto.KeyPair pairFromSeed = Crypto.mnemonicDeriveSignKeys((EverSdkContext)sdk.context(), (String)seed.phrase(), null, null, (Integer)seed.words());
            return new Credentials(pairFromSeed.publicKey(), pairFromSeed.secretKey());
        }
        throw new RuntimeException("Seed/mnemonic phrase checksum is not valid.");
    }

    public Abi.Signer signer() {
        if (this.equals(NONE)) {
            return new Abi.Signer.None();
        }
        return new Abi.Signer.Keys(this.keyPair());
    }

    public Crypto.KeyPair keyPair() {
        return new Crypto.KeyPair(this.publicKey, this.secretKey);
    }

    public String publicKeyTonSafe(Sdk sdk) throws EverSdkException {
        return Crypto.convertPublicKeyToTonSafeFormat((EverSdkContext)sdk.context(), (String)this.publicKey).tonPublicKey();
    }

    public BigInteger publicBigInt() {
        return Numbers.hexStringToBigInt((String)this.publicKey());
    }

    public BigInteger secretBigInt() {
        return Numbers.hexStringToBigInt((String)this.secretKey());
    }
}

