/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.contract.Contract;

public record OnchainConfig(Artifact<String, String> artifact, OnchainInfo info) {
    private static System.Logger logger = System.getLogger(OnchainConfig.class.getName());

    public static OnchainConfig LOAD_IF_EXISTS(String serializationPath) throws IOException {
        OnchainConfig conf = null;
        try {
            conf = OnchainConfig.LOAD(serializationPath);
        }
        catch (Exception e) {
            conf = OnchainConfig.EMPTY(serializationPath);
            LogUtils.warn(logger, e.getMessage());
        }
        return conf;
    }

    public static OnchainConfig EMPTY(String serializationPath) throws IOException {
        Path path = Paths.get(serializationPath, new String[0]);
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        OnchainConfig config = new OnchainConfig((Artifact<String, String>)((Object)jsonArtifact), new OnchainInfo(new ConcurrentHashMap<String, SavedContract>(), new ConcurrentHashMap<String, Credentials>()));
        config.sync();
        return config;
    }

    public static OnchainConfig LOAD(String serializationPath) throws JsonProcessingException {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER();
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        return new OnchainConfig((Artifact<String, String>)((Object)jsonArtifact), (OnchainInfo)mapper.readValue((String)jsonArtifact.get(), OnchainInfo.class));
    }

    public Credentials keys(String keysName) {
        return this.info().credentials().get(keysName);
    }

    private <T> T instatiateContract(Class<T> clazz, Sdk sdk, String contractName, Credentials credentials) throws JsonProcessingException {
        SavedContract contr = this.info().contracts().get(contractName);
        if (Optional.ofNullable(contr).isEmpty()) {
            return null;
        }
        return Contract.instantiate(clazz, sdk, contr.address(), ContractAbi.ofString(contr.abiJson()), credentials);
    }

    public <T> T contract(Class<T> clazz, Sdk sdk, String contractName, String keysName) throws JsonProcessingException {
        return this.instatiateContract(clazz, sdk, contractName, this.keys(keysName));
    }

    public <T> T contract(Class<T> clazz, Sdk sdk, String contractName) throws JsonProcessingException {
        return this.instatiateContract(clazz, sdk, contractName, Credentials.NONE);
    }

    public Contract addContract(String name, Contract contract) throws IOException {
        this.info().contracts().put(name, new SavedContract(contract.abi().json(), contract.address()));
        this.sync();
        logger.log(System.Logger.Level.INFO, "Saved contract: %s, name: %s".formatted(contract.address(), name));
        return contract;
    }

    public Credentials addKeys(String name, Credentials keys) throws IOException {
        this.info().credentials().put(name, keys);
        this.sync();
        logger.log(System.Logger.Level.INFO, "Saved keys: %s, name: %s".formatted(keys, name));
        return keys;
    }

    public void sync() throws IOException {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER();
        this.artifact().accept(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.info()));
    }

    public record OnchainInfo(Map<String, SavedContract> contracts, Map<String, Credentials> credentials) {
    }

    public record SavedContract(@JsonProperty(value="abi_json") String abiJson, String address) {
    }
}

