/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import tech.deplant.commons.Numbers;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.framework.Seed;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;

public record Credentials(@JsonProperty(value="public") String publicKey, @JsonProperty(value="secret") String secretKey) {
    public static final Credentials NONE = new Credentials("0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000");

    public static Credentials ofRandom(int contextId) throws EverSdkException {
        Crypto.KeyPair fromRandom = (Crypto.KeyPair)EverSdk.await((CompletableFuture)Crypto.generateRandomSignKeys((int)contextId));
        return new Credentials(fromRandom.publicKey(), fromRandom.secretKey());
    }

    public static Credentials ofResource(String resourceName) {
        try {
            return (Credentials)JsonContext.ABI_JSON_MAPPER().readValue(new JsonResource(resourceName).get(), Credentials.class);
        }
        catch (JsonProcessingException e) {
            return NONE;
        }
    }

    public static Credentials ofFile(String filePath) {
        try {
            return (Credentials)JsonContext.ABI_JSON_MAPPER().readValue(new JsonFile(filePath).get(), Credentials.class);
        }
        catch (JsonProcessingException e) {
            return NONE;
        }
    }

    public static Credentials ofSeed(int contextId, String seedString, int seedWords, Crypto.MnemonicDictionary dictionary) throws EverSdkException {
        return Credentials.ofSeed(contextId, new Seed(seedString, seedWords, dictionary));
    }

    public static Credentials ofSeed(int contextId, String seedString, int seedWords) throws EverSdkException {
        return Credentials.ofSeed(contextId, new Seed(seedString, seedWords));
    }

    public static Credentials ofSeed(int contextId, Seed seed) throws EverSdkException {
        if (seed.verifySeedPhrase(contextId)) {
            return seed.deriveCredentials(contextId);
        }
        throw new RuntimeException("Seed/mnemonic phrase checksum is not valid.");
    }

    public Abi.Signer signer() {
        if (this.equals(NONE)) {
            return new Abi.Signer.None();
        }
        return new Abi.Signer.Keys(this.keyPair());
    }

    public Crypto.KeyPair keyPair() {
        return new Crypto.KeyPair(this.publicKey, this.secretKey);
    }

    public String publicKeyTonSafe(int contextId) throws EverSdkException {
        return ((Crypto.ResultOfConvertPublicKeyToTonSafeFormat)EverSdk.await((CompletableFuture)Crypto.convertPublicKeyToTonSafeFormat((int)contextId, (String)this.publicKey))).tonPublicKey();
    }

    public BigInteger publicKeyBigInt() {
        return Numbers.hexStringToBigInt((String)this.publicKey());
    }

    public BigInteger secretKeyBigInt() {
        return Numbers.hexStringToBigInt((String)this.secretKey());
    }
}

