/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.utils;

import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.deplant.java4ever.utils.Objs;

public class Strings {
    public static boolean isEmpty(String str) {
        return Objs.isNull(str) || str.isBlank();
    }

    public static boolean isNotEmpty(String str) {
        return Objs.isNotNull(str) && !str.isBlank();
    }

    public static String notEmpty(String str) {
        if (Strings.isEmpty(str)) {
            throw new IllegalArgumentException();
        }
        return str;
    }

    public static String notEmpty(String str, String message) {
        if (Strings.isEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static <T> void notEmptyDo(String str, Consumer<String> action) {
        if (Strings.isNotEmpty(str)) {
            Objs.notNull(action).accept(str);
        }
    }

    public static <X extends Throwable> String notEmptyThrow(String str, Supplier<? extends X> exceptionSupplier) throws X {
        if (Strings.isEmpty(str)) {
            throw (Throwable)Objs.notNull(exceptionSupplier).get();
        }
        return str;
    }

    public static String notEmptyElse(String str, String defaultStr) {
        return Strings.isEmpty(str) ? str : Strings.notEmpty(defaultStr);
    }

    public static String notEmptyElseLazy(String str, Supplier<String> defaultSupplier) {
        return Strings.isEmpty(str) ? str : Strings.notEmpty(Objs.notNull(defaultSupplier).get());
    }

    public static boolean notEmptyEquals(String originalStr, String compareStr) {
        return Strings.notEmpty(originalStr).equals(Strings.notEmpty(compareStr));
    }

    public static String safeSubstr(String originalStr, int beginIndex, int endIndex) {
        return Strings.safeSubstr(originalStr, beginIndex, endIndex, false);
    }

    public static String safeSubstr(String originalStr, int beginIndex, int endIndex, boolean reversed) {
        if (Strings.isNotEmpty(originalStr) && beginIndex >= 0 && endIndex - beginIndex > 0 && endIndex <= originalStr.length()) {
            int len = originalStr.length();
            int begin = reversed ? len - endIndex : beginIndex;
            int end = reversed ? len - beginIndex : endIndex;
            return originalStr.substring(begin, end);
        }
        return "";
    }

    public static boolean safeSubstrEquals(String originalStr, int beginIndex, int endIndex, boolean reversed, String compareStr) {
        String substred = Strings.safeSubstr(originalStr, beginIndex, endIndex, reversed);
        return Strings.isNotEmpty(compareStr) && Strings.isNotEmpty(substred) && compareStr.equals(substred);
    }
}

