/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import uk.co.firstzero.diff.DiffListener;
import uk.co.firstzero.diff.Difference;
import uk.co.firstzero.diff.Report;
import uk.co.firstzero.diff.TwoWayHashMap;
import uk.co.firstzero.diff.exception.HeaderColumnsDoNotMatchException;
import uk.co.firstzero.diff.exception.KeyColumnsMissingException;

public class CsvDiff {
    private char delimiter;
    private String numberOfHeaders = "1";
    private String expectedFile;
    private String reachedFile;
    private List<DiffListener> listeners;
    private String keyColumns;
    private String[] keyColumnsToArray;
    private Report report;
    private HashMap<String, String[]> missingExpected = new HashMap();
    private HashMap<String, String[]> missingReached = new HashMap();
    private TwoWayHashMap headers = new TwoWayHashMap();
    private int intNumberOfHeaders = 1;
    private static Logger logger = Logger.getLogger(CsvDiff.class);

    public CsvDiff(String expectedFile, String reachedFile, char delimiter) {
        this.setExpectedFile(expectedFile);
        this.setReachedFile(reachedFile);
        this.setDelimiter(delimiter);
    }

    public void setDelimiter(char delimiter) {
        logger.trace((Object)("Setting delimiter to " + delimiter));
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setNumberOfHeaders(String numberOfHeaders) {
        logger.trace((Object)("Setting numberOfHeaders to " + numberOfHeaders));
        try {
            this.intNumberOfHeaders = Integer.valueOf(numberOfHeaders);
            this.numberOfHeaders = numberOfHeaders;
        }
        catch (Exception e) {
            System.out.println("Unable to convert to integer");
        }
    }

    public String getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    public void setExpectedFile(String expectedFile) {
        logger.trace((Object)("Setting expectedFile to " + expectedFile));
        this.expectedFile = expectedFile;
    }

    public String getExpectedFile() {
        return this.expectedFile;
    }

    public void setReachedFile(String reachedFile) {
        logger.trace((Object)("Setting reachedFile to " + reachedFile));
        this.reachedFile = reachedFile;
    }

    public String getReachedFile() {
        return this.reachedFile;
    }

    public void setListeners(List<DiffListener> listeners) {
        logger.trace((Object)("Setting number of listeners to " + listeners.size()));
        this.listeners = listeners;
    }

    public List<DiffListener> getListeners() {
        return this.listeners;
    }

    public void setKeyColumns(String keyColumns) {
        logger.trace((Object)("Setting number of keyColumns to " + keyColumns.length()));
        this.keyColumns = keyColumns;
        this.keyColumnsToArray = keyColumns.split(";");
    }

    public String getKeyColumns() {
        return this.keyColumns;
    }

    public void diff() throws KeyColumnsMissingException, HeaderColumnsDoNotMatchException, IOException {
        logger.debug((Object)"START diff");
        int rowCount = 0;
        int totalMismatches = 0;
        if (this.keyColumns == null || this.keyColumnsToArray.length == 0) {
            throw new KeyColumnsMissingException("Missing key columns");
        }
        try {
            logger.trace((Object)("Initialising CSVReader for " + this.expectedFile));
            CSVReader fileE = new CSVReader((Reader)new FileReader(this.expectedFile), this.delimiter);
            logger.trace((Object)("Initialising CSVReader for " + this.reachedFile));
            CSVReader fileR = new CSVReader((Reader)new FileReader(this.reachedFile), this.delimiter);
            logger.trace((Object)"Determining Headers");
            this.determineHeaders(fileE, fileR);
            String[] expected = fileE.readNext();
            String[] reached = fileR.readNext();
            while (expected != null || reached != null) {
                logger.trace((Object)("Read from expected " + expected));
                logger.trace((Object)("Read from reached " + reached));
                Object keyExpected = "";
                Object keyReached = "";
                for (int i = 0; i < this.keyColumnsToArray.length; ++i) {
                    int keyHeaderLocation = this.headers.get(this.keyColumnsToArray[i]);
                    if (expected != null) {
                        keyExpected = ((String)keyExpected).length() == 0 ? expected[keyHeaderLocation] : (String)keyExpected + "_" + expected[keyHeaderLocation];
                    }
                    if (reached != null) {
                        keyReached = ((String)keyReached).length() == 0 ? reached[keyHeaderLocation] : (String)keyReached + "_" + reached[keyHeaderLocation];
                    }
                    logger.trace((Object)("Building Expected key " + (String)keyExpected));
                    logger.trace((Object)("Building Reached key " + (String)keyReached));
                }
                logger.debug((Object)("Expected key " + (String)keyExpected));
                logger.debug((Object)("Reached key " + (String)keyReached));
                if (((String)keyExpected).compareTo((String)keyReached) == 0) {
                    logger.debug((Object)("KEYS " + (String)keyExpected + " " + (String)keyExpected + " MATCHED"));
                    totalMismatches += this.diffColumns(expected, reached, (String)keyExpected, rowCount);
                } else {
                    if (expected != null && !"".equals(keyExpected)) {
                        this.missingExpected.put((String)keyExpected, expected);
                    }
                    if (reached != null && !"".equals(keyReached)) {
                        this.missingReached.put((String)keyReached, reached);
                    }
                }
                if (this.missingExpected.containsKey(keyReached)) {
                    logger.debug((Object)("FOUND REACHED KEY " + (String)keyReached + " in missingExpected"));
                    String[] localExpected = this.missingExpected.get(keyReached);
                    String[] localReached = reached;
                    Object localKeyExpected = keyReached;
                    this.missingExpected.remove(keyReached);
                    this.missingReached.remove(keyReached);
                    totalMismatches += this.diffColumns(localExpected, localReached, (String)localKeyExpected, rowCount);
                }
                if (this.missingReached.containsKey(keyExpected)) {
                    logger.debug((Object)("FOUND EXPECTED KEY " + (String)keyExpected + " in missingReached"));
                    String[] localReached = this.missingReached.get(keyExpected);
                    String[] localExpected = expected;
                    Object localKeyReached = keyExpected;
                    this.missingReached.remove(keyExpected);
                    this.missingExpected.remove(keyExpected);
                    totalMismatches += this.diffColumns(localExpected, localReached, (String)localKeyReached, rowCount);
                }
                expected = null;
                reached = null;
                expected = fileE.readNext();
                reached = fileR.readNext();
                ++rowCount;
            }
            Iterator<String> i = this.missingExpected.keySet().iterator();
            while (i.hasNext()) {
                Difference difference = new Difference(rowCount, null, "Missing Expected", i.next(), null, null);
                logger.info((Object)difference.toString());
                if (this.report == null) continue;
                this.report.write(difference);
            }
            i = this.missingReached.keySet().iterator();
            while (i.hasNext()) {
                Difference difference = new Difference(rowCount, null, "Missing Reached", null, i.next(), null);
                logger.info((Object)difference.toString());
                if (this.report == null) continue;
                this.report.write(difference);
            }
            System.out.println("Number of mismatches: " + totalMismatches);
            System.out.println("Number of missing Control lines: " + this.missingExpected.size());
            System.out.println("Number of missing Test lines: " + this.missingReached.size());
        }
        catch (IOException e) {
            System.out.println("Unable to read expected or reached file");
            throw e;
        }
    }

    private int diffColumns(String[] expected, String[] reached, String keyExpected, int rowCount) {
        logger.debug((Object)"START diffColumns");
        int totalMismatches = 0;
        for (int i = 0; i < expected.length; ++i) {
            logger.trace((Object)("Column at line " + rowCount + " column " + i + " in expected " + expected[i] + " - in reached " + reached[i]));
            String control = expected[i];
            String test = reached[i];
            boolean ignore = control.compareTo(test) == 0;
            logger.trace((Object)("Before firing listeners - ignore is " + ignore));
            if (control.compareTo(test) != 0 && this.listeners != null) {
                Iterator<DiffListener> iterator = this.listeners.iterator();
                while (true) {
                    DiffListener listener;
                    boolean iteratorIgnore;
                    if (!(iteratorIgnore = (listener = iterator.next()).ignore(this.headers.get(i), control, test))) {
                        continue;
                    }
                    ignore = iteratorIgnore;
                }
            }
            logger.trace((Object)("After firing listeners - ignore is " + ignore));
            if (ignore) continue;
            ++totalMismatches;
            try {
                Difference difference = new Difference(rowCount, this.headers.get(i), "MISMATCH", control, test, keyExpected);
                logger.info((Object)difference.toString());
                this.report.write(difference);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.debug((Object)"STOP diffColumns");
        return totalMismatches;
    }

    private void determineHeaders(CSVReader fileE, CSVReader fileR) throws HeaderColumnsDoNotMatchException {
        logger.debug((Object)"START determineHeaders");
        try {
            for (int i = 1; i <= this.intNumberOfHeaders; ++i) {
                String[] headerExpected = fileE.readNext();
                String[] headerReached = fileR.readNext();
                logger.trace((Object)("Read from expected " + headerExpected.toString()));
                logger.trace((Object)("Read from reached " + headerReached.toString()));
                logger.debug((Object)("Number of columns in header for " + fileE + " at line " + i + " - " + headerExpected.length));
                logger.debug((Object)("Number of columns in header for " + fileR + " at line " + i + " - " + headerReached.length));
                if (headerExpected.length != headerReached.length) {
                    throw new HeaderColumnsDoNotMatchException("Number of header columns do not match on line " + this.intNumberOfHeaders);
                }
                for (int j = 0; j < headerExpected.length; ++j) {
                    logger.trace((Object)("Header at line " + i + " column " + j + " " + headerExpected[j]));
                    if (!this.headers.containsKey(j)) {
                        logger.trace((Object)("Adding header - " + headerExpected[j]));
                        this.headers.put(j, headerExpected[j]);
                        continue;
                    }
                    if (headerExpected[j] == this.headers.get(j)) continue;
                    Object header = this.headers.get(j);
                    this.headers.remove(j);
                    header = (String)header + "_" + headerExpected[j];
                    logger.trace((Object)("Adding header - " + (String)header));
                    this.headers.put(j, (String)header);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Unable to read files");
        }
        logger.trace((Object)"STOP determineHeaders");
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Report getReport() {
        return this.report;
    }
}

