/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.diff;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import uk.co.firstzero.diff.Difference;
import uk.co.firstzero.diff.Report;

public class CsvReport
implements Report {
    private CSVWriter writer;
    private String separator = ",";

    public CsvReport(String fileName) throws IOException {
        this.open(fileName);
    }

    @Override
    public void open(String fileName) throws IOException {
        this.writer = new CSVWriter((Writer)new FileWriter(fileName), this.separator.charAt(0));
        this.writeHeader();
    }

    public void writeHeader() {
        String[] result = new String[]{"Line Number", "Key", "Column", "Mismatch Type", "Expected", "Reached", "Difference"};
        this.writer.writeNext(result);
    }

    @Override
    public void write(Difference difference) throws IOException {
        String diff;
        try {
            float expected = Float.valueOf(difference.getExpected()).floatValue();
            float reached = Float.valueOf(difference.getExpected()).floatValue();
            diff = Float.toString(expected - reached);
        }
        catch (Exception e) {
            diff = "";
        }
        String[] result = new String[]{difference.getLineNumber().toString(), difference.getKey(), difference.getColumn(), difference.getMismatchType(), difference.getExpected(), difference.getReached(), diff};
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

